/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.api.customtable.model;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CustomHyperParam
implements Serializable {
    private static final long serialVersionUID = -8415807349146880319L;
    private String name;
    private String alias;
    private boolean isRequired;
    private ParamType paramType;
    private Object value;

    public CustomHyperParam() {
    }

    public CustomHyperParam(String name, String alias, boolean isRequired) {
        if (this.isErrorParamName(name)) {
            throw new IllegalArgumentException("The parameter name should start with an English letter and can be followed by numbers and underscores.");
        }
        this.name = name;
        this.alias = alias;
        this.isRequired = isRequired;
    }

    private boolean isErrorParamName(String source) {
        if (source == null || "".equals(source)) {
            return true;
        }
        Pattern regxPattern = Pattern.compile("^[a-zA-Z][a-zA-Z0-9_]*$");
        Matcher m = regxPattern.matcher(source);
        return !m.matches();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setRequired(boolean required) {
        this.isRequired = required;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public ParamType getParamType() {
        return this.paramType;
    }

    public void setParamType(ParamType paramType) {
        this.paramType = paramType;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public static enum ParamType {
        Integer_Type,
        Double_Type,
        Long_Type,
        String_Type,
        Date_Type,
        Time_Type,
        Datetime_Type,
        Boolean_Type;

    }
}

