/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.modeler.api;

import java.io.Serializable;

public class ApiResponse<T>
implements Serializable {
    private int code;
    private String message;
    private T data;

    public ApiResponse(int code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public static <T> ApiResponse<T> success(T data) {
        return new ApiResponse<T>(ApiCode.SUCCESS.code, ApiCode.SUCCESS.message, data);
    }

    public static <T> ApiResponse<T> fail(String message) {
        return new ApiResponse<Object>(ApiCode.FAIL.code, message, null);
    }

    public static <T> ApiResponse<T> error(Exception e) {
        return new ApiResponse<Object>(ApiCode.ERROR.code, e.getMessage(), null);
    }

    public static <T> ApiResponse<T> error(int code, String message) {
        return new ApiResponse<Object>(code, message, null);
    }

    public static enum BusinessErrorCode {
        NO_PERMISSION(20100100, "no permission!"),
        NOT_FOUND_MODEL(20100001, "model does not exists!"),
        QUERY_FIELD_ERROR(20100002, "query field failed!"),
        WRONG_CALL_METHOD(20100003, "wrong calling method!"),
        UNKNOWN_DATEGRANULARITY(20100004, "unknown dategranularity '%s'!"),
        MODEL_NOT_DEPLOYED(20100005, "model not deployed!"),
        UNKNOWN_DIMENSION(20100006, "unknown dimension '%s'!"),
        TIME_OUT(20100007, "call method time out!"),
        UNKNOWN_FIELD(20100008, "unknown fieldName '%s'!"),
        UNKNOWN_DIMENSION_FILTER_NAME(20100009, "the filter name  '%s' is not in 'dimensions'!"),
        QING_DB_CONNECTION_EXCPETION(20100010, "qing db connection error!"),
        MODELSET_DISABLED(20100011, "modelSet is disabled!"),
        NO_SUPPORT_DATASOURCE(20100012, "unsupport datasource!"),
        DATAWAREHOUSECONFIG_NOT_EXIST(20100013, "dataWarehouseConfig not exist!"),
        MODEL_CHECK_ERROR(20100014, "model check error,please check model!"),
        DPP_ENGINE_VERSION_EXCEPTION(20100015, "inconsistent client and engine versions!"),
        PARAMS_ERROR(20100016, "the parameter is invalid:'%s'!"),
        UNKNOWN_METRIC(20100017, "unknown metric '%s'!"),
        NO_QING_MODELER_LICENSE(20100018, "no qing modeler license!"),
        ERROR_DATA_AUTH(20100019, "error model data auth!"),
        NONSUPPORT_QING_MODELER(20100020, "the current version does not support the [QING MODELER] module!"),
        DPP_MODEL_CONVERT_EXCEPTION(20100021, "dpp model convert error!"),
        UNKNOWN_FILTER_NAME(20100022, "the filter name  '%s' is not in 'dimensions' and 'metricIds'!"),
        UNKNOWN_SORT_ITEM(20100023, "unknown sort fieldName '%s'!"),
        MACRO_ERROR(20100024, "macro error"),
        NO_PRESET_ENCRYPT_LICENSE(20100025, "no preset model license!"),
        DATE_DIMENSION_ERROR(20100026, "data dimension granularity '%s' can not convert to '%s'."),
        QUERY_CONTEXT_EMPTY(20100027, "query context is empty."),
        NON_AVAILABLE_METRIC_CUBE(20100028, "no available metric materialized table."),
        MODEL_IS_BEING_MATERIALIZED(20100029, "the model is being materialized.");

        private final int errorCode;
        private final String errorMsg;

        private BusinessErrorCode(int errorCode, String errorMsg) {
            this.errorCode = errorCode;
            this.errorMsg = errorMsg;
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public String getErrorMsg() {
            return this.errorMsg;
        }

        public static BusinessErrorCode getByErrorCode(int errorCode) {
            for (BusinessErrorCode businessErrorCode : BusinessErrorCode.values()) {
                if (businessErrorCode.getErrorCode() != errorCode) continue;
                return businessErrorCode;
            }
            return null;
        }
    }

    public static enum ApiCode {
        SUCCESS(200, "Request successful!"),
        FAIL(400, "Request failure!"),
        ERROR(500, "Server error!"),
        TIME_OUT(408, "time out!");

        private final int code;
        private final String message;

        private ApiCode(int code, String message) {
            this.code = code;
            this.message = message;
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

