/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.modeler.api.exception;

import com.kingdee.bos.qing.modeler.api.ApiResponse;

public class ModelException
extends Exception {
    private int _errorCode;

    protected ModelException(String message, Throwable e, int errorCode) {
        super(message, e);
        this._errorCode = errorCode;
    }

    protected ModelException(Throwable e, int errorCode) {
        super(e);
        this._errorCode = errorCode;
    }

    public ModelException(String message, int errorCode) {
        super(message);
        this._errorCode = errorCode;
    }

    protected ModelException(int errorCode) {
        this._errorCode = errorCode;
    }

    public int getErrorCode() {
        return this._errorCode;
    }

    public ModelException(int errorCode, String message) {
        super(message);
        this._errorCode = errorCode;
    }

    public ModelException(ApiResponse.BusinessErrorCode businessErrorCode) {
        super(businessErrorCode.getErrorMsg());
        this._errorCode = businessErrorCode.getErrorCode();
    }

    public ModelException(ApiResponse.BusinessErrorCode businessErrorCode, String ... args) {
        super(String.format(businessErrorCode.getErrorMsg(), args));
        this._errorCode = businessErrorCode.getErrorCode();
    }

    public ModelException(ApiResponse.ApiCode apiCode, Throwable cause) {
        super(cause.getMessage(), cause);
        this._errorCode = apiCode.getCode();
    }

    public ModelException(String message, Throwable cause) {
        super(message, cause);
        this._errorCode = ApiResponse.ApiCode.FAIL.getCode();
    }

    public ModelException(String message) {
        super(message);
        this._errorCode = ApiResponse.ApiCode.FAIL.getCode();
    }

    public ModelException(Throwable cause, String message, Object ... args) {
        super(String.format(message, args), cause);
        this._errorCode = ApiResponse.ApiCode.FAIL.getCode();
    }

    public static ModelException create(String message, Object ... args) {
        return new ModelException(String.format(message, args));
    }

    public static ModelException create(String message, Throwable cause, Object ... args) {
        return new ModelException(String.format(message, args), cause);
    }
}

