/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.modeler.api.response;

import com.kingdee.bos.qing.modeler.api.ApiResponse;
import com.kingdee.bos.qing.modeler.api.exception.ModelException;
import com.kingdee.bos.qing.modeler.api.response.DataType;
import com.kingdee.bos.qing.modeler.api.response.ModelField;
import com.kingdee.bos.qing.modeler.api.response.Row;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DataRow
implements Row {
    private Map<String, Integer> fieldNameIndexMap = new HashMap<String, Integer>(16);
    private int size;
    private Object[] data;

    public DataRow(ModelField[] fields, Object[] data) {
        this.size = fields.length;
        for (int i = 0; i < fields.length; ++i) {
            ModelField field = fields[i];
            this.fieldNameIndexMap.put(field.getFieldName(), i);
        }
        this.data = data;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Object get(int colSize) {
        if (this.size <= colSize) {
            throw new IndexOutOfBoundsException("index out of the bounds");
        }
        return this.data[colSize];
    }

    @Override
    public Object get(String fieldName) throws NoSuchFieldException, ModelException {
        return this.data[this.getFieldIndex(fieldName)];
    }

    private Integer getFieldIndex(String fieldName) throws ModelException {
        try {
            Integer index = this.fieldNameIndexMap.get(fieldName);
            if (index == null) {
                throw new ModelException("can't found the fieldName: " + fieldName);
            }
            return index;
        }
        catch (Exception e) {
            throw new ModelException(ApiResponse.BusinessErrorCode.UNKNOWN_FIELD, fieldName);
        }
    }

    @Override
    public String getString(int colSize) throws IndexOutOfBoundsException, ModelException {
        if (this.size <= colSize) {
            throw new IndexOutOfBoundsException();
        }
        Object value = DataType.convertValue(DataType.STRING, this.data[colSize]);
        return value == null ? null : value.toString();
    }

    @Override
    public String getString(String fieldName) throws ModelException {
        Integer fieldIndex = this.getFieldIndex(fieldName);
        Object value = DataType.convertValue(DataType.STRING, this.data[fieldIndex]);
        return value == null ? null : value.toString();
    }

    @Override
    public Long getLong(int colSize) throws ModelException {
        if (this.size <= colSize) {
            throw new IndexOutOfBoundsException();
        }
        Object value = DataType.convertValue(DataType.INT, this.data[colSize]);
        return value == null ? null : (Long)value;
    }

    @Override
    public Long getLong(String fieldName) throws ModelException {
        Integer fieldIndex = this.getFieldIndex(fieldName);
        Object value = DataType.convertValue(DataType.INT, this.data[fieldIndex]);
        return value == null ? null : (Long)value;
    }

    @Override
    public Boolean getBoolean(int colSize) throws ModelException {
        if (this.size <= colSize) {
            throw new IndexOutOfBoundsException();
        }
        Object value = DataType.convertValue(DataType.BOOLEAN, this.data[colSize]);
        return value == null ? null : (Boolean)value;
    }

    @Override
    public Boolean getBoolean(String fieldName) throws ModelException {
        Integer fieldIndex = this.getFieldIndex(fieldName);
        Object value = DataType.convertValue(DataType.BOOLEAN, this.data[fieldIndex]);
        return value == null ? null : (Boolean)value;
    }

    @Override
    public BigDecimal getBigDecimal(int colSize) throws ModelException {
        if (this.size <= colSize) {
            throw new IndexOutOfBoundsException();
        }
        Object value = DataType.convertValue(DataType.NUMBER, this.data[colSize]);
        return value == null ? null : (BigDecimal)value;
    }

    @Override
    public BigDecimal getBigDecimal(String fieldName) throws ModelException {
        Integer fieldIndex = this.getFieldIndex(fieldName);
        Object value = DataType.convertValue(DataType.NUMBER, this.data[fieldIndex]);
        return value == null ? null : (BigDecimal)value;
    }

    @Override
    public Date getDate(int colSize) throws ModelException {
        if (this.size <= colSize) {
            throw new IndexOutOfBoundsException();
        }
        Object value = DataType.convertValue(DataType.DATE, this.data[colSize]);
        return value == null ? null : (Date)value;
    }

    @Override
    public Date getDate(String fieldName) throws ModelException {
        Integer fieldIndex = this.getFieldIndex(fieldName);
        Object value = DataType.convertValue(DataType.DATE, this.data[fieldIndex]);
        return value == null ? null : (Date)value;
    }

    @Override
    public Timestamp getTimestamp(int colSize) throws ModelException {
        if (this.size <= colSize) {
            throw new IndexOutOfBoundsException();
        }
        Object value = DataType.convertValue(DataType.DATETIME, this.data[colSize]);
        return value == null ? null : (Timestamp)value;
    }

    @Override
    public Timestamp getTimestamp(String fieldName) throws ModelException {
        Integer fieldIndex = this.getFieldIndex(fieldName);
        Object value = DataType.convertValue(DataType.DATETIME, this.data[fieldIndex]);
        return value == null ? null : (Timestamp)value;
    }
}

