/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.modeler.api.response;

import com.kingdee.bos.qing.modeler.api.exception.ModelException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public enum DataType {
    BOOLEAN,
    INT,
    NUMBER,
    DATE,
    DATETIME,
    STRING;


    public static Object convertValue(DataType dataType, Object value) throws ModelException {
        if (value == null) {
            return null;
        }
        try {
            switch (dataType) {
                case BOOLEAN: {
                    if (value instanceof Boolean) {
                        return value;
                    }
                    if (!(value instanceof String)) {
                        if (value instanceof Number) {
                            return !"0".equals(value.toString());
                        }
                        throw new ModelException("Can't not convert value to Boolean: " + value);
                    }
                    return Boolean.parseBoolean((String)value) || "1".equals(value);
                }
                case STRING: {
                    if (value instanceof String) {
                        return value;
                    }
                    return value.toString();
                }
                case INT: {
                    if (value instanceof Long) {
                        return value;
                    }
                    if (value instanceof BigDecimal) {
                        return ((BigDecimal)value).longValue();
                    }
                    return Long.valueOf(value.toString());
                }
                case NUMBER: {
                    if (value instanceof BigDecimal) {
                        return value;
                    }
                    if (value instanceof Long) {
                        return BigDecimal.valueOf((Long)value);
                    }
                    if (value instanceof Integer) {
                        return BigDecimal.valueOf(((Integer)value).intValue());
                    }
                    if (value instanceof Double) {
                        return BigDecimal.valueOf((Double)value);
                    }
                    return new BigDecimal(value.toString());
                }
                case DATE: {
                    if (value instanceof Date) {
                        return value;
                    }
                    if (value instanceof Calendar) {
                        return ((Calendar)value).getTime();
                    }
                    if (value instanceof Long) {
                        return new Date((Long)value);
                    }
                    throw new ModelException("Can't not convert value to Date:" + value);
                }
                case DATETIME: {
                    if (value instanceof Timestamp) {
                        return value;
                    }
                    if (value instanceof Long) {
                        return new Timestamp((Long)value);
                    }
                    if (value instanceof Date) {
                        return new Timestamp(((Date)value).getTime());
                    }
                    if (value instanceof Calendar) {
                        return new Timestamp(((Calendar)value).getTimeInMillis());
                    }
                    throw new ModelException("Can't not convert value to Timestamp:" + value);
                }
            }
            return value;
        }
        catch (Exception e) {
            throw new ModelException(e, "Can't cast %s to %s", new Object[]{value.toString(), dataType});
        }
    }
}

