/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.distribute.resource;

import com.kingdee.bos.qing.common.distribute.resource.IServerNodeChangedListener;
import com.kingdee.bos.qing.common.distribute.resource.QingServerNodeObserver;
import com.kingdee.bos.qing.common.distribute.resource.QingServiceNodeMeta;
import com.kingdee.bos.qing.common.distribute.resource.ServerResourceMgr;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.common.strategy.framework.ITaskDistributeStrategy;
import com.kingdee.bos.qing.util.SystemPropertyUtil;
import com.kingdee.bos.qing.util.ThreadPoolManage;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class QingServerNodeMonitor {
    private static final QingServerNodeMonitor instance = new QingServerNodeMonitor();
    private QingServerNodeObserver qingServerNodeObserver;
    private QingServiceNodeMeta nodeMeta = new QingServiceNodeMeta();

    public static QingServerNodeMonitor getInstance() {
        return instance;
    }

    private QingServerNodeMonitor() {
        ThreadPoolManage.scheduleAtFixRate(new Runnable(){

            @Override
            public void run() {
                QingServerNodeMonitor.this.nodeMeta.refreshLocalMetas();
            }
        }, 60000L, 60000L, TimeUnit.MILLISECONDS);
    }

    public void startUp() {
        ITaskDistributeStrategy taskStrategy = CustomStrategyRegistrar.getStrategy(ITaskDistributeStrategy.class);
        if (null == taskStrategy) {
            return;
        }
        this.qingServerNodeObserver = taskStrategy.createServerNodeObserver();
        this.qingServerNodeObserver.addListener(taskStrategy.getServerNodeListener());
        this.qingServerNodeObserver.addListener(ServerResourceMgr.getInstance());
        this.qingServerNodeObserver.initialize();
        boolean isEnable = SystemPropertyUtil.getBoolean("qing.distribute.task.enable", false);
        if (isEnable) {
            ServerResourceMgr.getInstance().start();
            return;
        }
    }

    public void addNodeListener(IServerNodeChangedListener nodeChangedListener) {
        this.qingServerNodeObserver.addListener(nodeChangedListener);
    }

    public Set<String> getAllServerNodeIPs() {
        return this.qingServerNodeObserver.getAllServerNodeIps();
    }

    public QingServiceNodeMeta getNodeMeta() {
        return this.nodeMeta;
    }
}

