/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.distribute.session;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.distribute.resource.CalcServerResource;
import com.kingdee.bos.qing.common.distribute.resource.ICalcServerResourceUpdateListener;
import com.kingdee.bos.qing.common.distribute.resource.ServerResourceMgr;
import com.kingdee.bos.qing.common.distribute.resource.ThreadResourceStatus;
import com.kingdee.bos.qing.common.distribute.session.UserSessionMgr;
import com.kingdee.bos.qing.common.distribute.task.AbstractTaskChannel;
import com.kingdee.bos.qing.common.distribute.task.DistributeTaskMgr;
import com.kingdee.bos.qing.common.distribute.task.RemoteSubmitState;
import com.kingdee.bos.qing.common.distribute.task.TaskEvent;
import com.kingdee.bos.qing.common.distribute.task.TaskEventType;
import com.kingdee.bos.qing.common.distribute.task.TaskHelper;
import com.kingdee.bos.qing.common.distribute.task.TaskInvokeListenerImpl;
import com.kingdee.bos.qing.common.distribute.task.TaskRequest;
import com.kingdee.bos.qing.common.distribute.task.TaskResponse;
import com.kingdee.bos.qing.common.framework.model.QingServiceAsynDispatcherModel;
import com.kingdee.bos.qing.common.framework.server.annotation.iotask.IOTaskServiceHelper;
import com.kingdee.bos.qing.common.framework.server.annotation.longtime.LongTimeServiceHelper;
import com.kingdee.bos.qing.common.framework.server.annotation.rptexec.RptExecServiceHelper;
import com.kingdee.bos.qing.common.framework.server.task.AsynServerRequestInvokeTask;
import com.kingdee.bos.qing.common.thread.ThreadPoolMonitor;
import com.kingdee.bos.qing.response.ResponseErrorWrap;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.SystemPropertyUtil;
import com.kingdee.bos.qing.util.ThreadPoolManage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class UserRequestSession
implements ICalcServerResourceUpdateListener {
    private static long TIMEOUT_TIME = SystemPropertyUtil.getLong("qing.user.session.timeout", 60000L);
    private volatile long touchTime = System.currentTimeMillis();
    private Map<String, ReqInvokeStatistic> reqStatisticMap = new HashMap<String, ReqInvokeStatistic>(2);
    private Map<String, Integer> threadPoolMaxUsage = new HashMap<String, Integer>(2);
    private Map<String, Integer> tokenUsedCounts = new HashMap<String, Integer>(2);
    private Map<String, LinkedList<AsynServerRequestInvokeTask>> threadWaitingTasks = new HashMap<String, LinkedList<AsynServerRequestInvokeTask>>(2);
    private String sessionId;
    private int totalTokenUsed = 0;
    private volatile boolean isClosed = false;
    private String userId;

    public UserRequestSession(String sessionId, String userId) {
        this.sessionId = sessionId;
        this.userId = userId;
        ServerResourceMgr.getInstance().regResourceChangeListener(this);
    }

    public synchronized boolean closeIfNotBusy() {
        for (Map.Entry<String, LinkedList<AsynServerRequestInvokeTask>> entry : this.threadWaitingTasks.entrySet()) {
            List waitingTasks = entry.getValue();
            if (waitingTasks.size() <= 0) continue;
            return false;
        }
        if (this.totalTokenUsed == 0) {
            this.isClosed = true;
        }
        return this.isClosed;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public synchronized int getBlockSize(String threadPoolName) {
        List blockList = this.threadWaitingTasks.get(threadPoolName);
        if (null != blockList) {
            return blockList.size();
        }
        return 0;
    }

    public synchronized boolean isCanDel() {
        long recentTouchTime = this.getTouchTime();
        long notAliveTime = System.currentTimeMillis() - recentTouchTime;
        return notAliveTime >= TIMEOUT_TIME && !this.hasBlockingTasks() && this.totalTokenUsed == 0;
    }

    public String getUserId() {
        return this.userId;
    }

    public void touchMe() {
        this.touchTime = System.currentTimeMillis();
    }

    private synchronized boolean hasBlockingTasks() {
        for (Map.Entry<String, LinkedList<AsynServerRequestInvokeTask>> entry : this.threadWaitingTasks.entrySet()) {
            List waitingTasks = entry.getValue();
            if (waitingTasks.size() <= 0) continue;
            return true;
        }
        return false;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    private void addBlockedTask(String poolName, AsynServerRequestInvokeTask invokeTask) {
        invokeTask.setBlockBeginTime(System.currentTimeMillis());
        LinkedList<AsynServerRequestInvokeTask> waitingTasks = this.threadWaitingTasks.get(poolName);
        if (null == waitingTasks) {
            waitingTasks = new LinkedList();
            waitingTasks.add(invokeTask);
            this.threadWaitingTasks.put(poolName, waitingTasks);
        } else {
            waitingTasks.add(invokeTask);
        }
        LogUtil.warn("QingDistributeTask--thread task blocked\uff0cthread pool name :" + poolName + ",task desc:" + invokeTask.getTaskDesc() + ", current block size=" + waitingTasks.size() + ",currentServer:" + DistributeTaskMgr.getInstance().getLocalIp() + " ,userId=" + this.userId);
    }

    public long getTouchTime() {
        return this.touchTime;
    }

    private ThreadPoolManage.QingThreadPoolName getThreadPoolName(Object service, String methodName) {
        ThreadPoolManage.QingThreadPoolName threadPoolName = ThreadPoolManage.QingThreadPoolName.QING_SHORT_TIME_TASK_HANDLER;
        if (LongTimeServiceHelper.isLongTimeService(service, methodName)) {
            threadPoolName = ThreadPoolManage.QingThreadPoolName.QING_LONG_TIME_TASK_HANDLER;
        } else if (RptExecServiceHelper.isRptExecService(service, methodName)) {
            threadPoolName = ThreadPoolManage.QingThreadPoolName.QING_RPT_EXEC_TASK_HANDLER;
        } else if (IOTaskServiceHelper.isIOTaskService(service, methodName)) {
            threadPoolName = ThreadPoolManage.QingThreadPoolName.QING_IO_MASTER_TASK_HANDLER;
        }
        return threadPoolName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceInvokeRemoteReq(String taskId, TaskRequest taskRequest, QingContext qingContext, Object service) {
        QingServiceAsynDispatcherModel dispatcherModel = taskRequest.getTaskModel();
        dispatcherModel.setDispatchCount(dispatcherModel.getDispatchCount() + 1);
        ThreadPoolManage.QingThreadPoolName threadPoolName = this.getThreadPoolName(service, dispatcherModel.getMethodName());
        AsynServerRequestInvokeTask invokeTask = null;
        UserRequestSession userRequestSession = this;
        synchronized (userRequestSession) {
            if (this.isClosed || this.aquireToken(threadPoolName)) {
                invokeTask = this.createInvokeTask(dispatcherModel, qingContext, service);
                invokeTask.setSourceServer(taskRequest.getFromServer());
                invokeTask.setTaskId(taskId);
                invokeTask.setThreadPoolName(threadPoolName);
                TaskResponse taskResponse = new TaskResponse();
                taskResponse.setSessionId(qingContext.getSessionID());
                taskResponse.setThreadPoolName(threadPoolName.name());
                taskResponse.setStateCode(0);
                taskResponse.setThreadWaitingTaskInSession(this.threadBlockSize());
                ThreadPoolMonitor.ThreadPoolStatistic statistic = ThreadPoolMonitor.getInstance().getThreadPoolStatistic(threadPoolName);
                if (null != statistic) {
                    taskResponse.setCurrentRunningSize(statistic.getRunningSize());
                }
                taskResponse.setRemoteServer(DistributeTaskMgr.getInstance().getLocalIp());
                TaskEvent taskEvent = new TaskEvent();
                taskEvent.setEventType(TaskEventType.RESPONSE);
                taskEvent.setData(taskResponse);
                taskEvent.setTaskId(taskId);
                DistributeTaskMgr.getInstance().sendTaskResponse(taskRequest.getFromServer(), taskEvent);
                this.executeTask(qingContext, threadPoolName, invokeTask);
            } else {
                invokeTask = this.createInvokeTask(dispatcherModel, qingContext, service);
                invokeTask.setSourceServer(taskRequest.getFromServer());
                invokeTask.setTaskId(taskId);
                invokeTask.setThreadPoolName(threadPoolName);
                TaskResponse taskResponse = new TaskResponse();
                taskResponse.setSessionId(qingContext.getSessionID());
                taskResponse.setThreadPoolName(threadPoolName.name());
                taskResponse.setStateCode(3);
                taskResponse.setThreadWaitingTaskInSession(this.threadBlockSize());
                taskResponse.setRemoteServer(DistributeTaskMgr.getInstance().getLocalIp());
                ThreadPoolMonitor.ThreadPoolStatistic statistic = ThreadPoolMonitor.getInstance().getThreadPoolStatistic(threadPoolName);
                if (null != statistic) {
                    taskResponse.setCurrentRunningSize(statistic.getRunningSize());
                }
                TaskEvent taskEvent = new TaskEvent();
                taskEvent.setEventType(TaskEventType.RESPONSE);
                taskEvent.setData(taskResponse);
                taskEvent.setTaskId(taskId);
                DistributeTaskMgr.getInstance().sendTaskResponse(taskRequest.getFromServer(), taskEvent);
                this.addBlockedTask(threadPoolName.name(), invokeTask);
            }
        }
    }

    private AsynServerRequestInvokeTask createInvokeTask(QingServiceAsynDispatcherModel dispatcherModel, QingContext qingContext, Object service) {
        AsynServerRequestInvokeTask invokeActionTask = TaskHelper.createInvokeTask(dispatcherModel, qingContext, service);
        ThreadPoolManage.QingThreadPoolName poolName = this.getThreadPoolName(service, dispatcherModel.getMethodName());
        TaskInvokeListenerImpl invokeListener = new TaskInvokeListenerImpl(poolName, this);
        invokeActionTask.setInvokeTaskListener(invokeListener);
        return invokeActionTask;
    }

    public synchronized Map<String, Integer> threadBlockSize() {
        HashMap<String, Integer> result = new HashMap<String, Integer>(3);
        for (Map.Entry<String, LinkedList<AsynServerRequestInvokeTask>> entry : this.threadWaitingTasks.entrySet()) {
            List waitingTasks = entry.getValue();
            if (null == waitingTasks || waitingTasks.size() == 0) continue;
            result.put(entry.getKey(), waitingTasks.size());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeDirect(AsynServerRequestInvokeTask task) {
        this.touchMe();
        QingContext qingContext = task.getContext();
        ThreadPoolManage.QingThreadPoolName threadPoolName = task.getThreadPoolName();
        UserRequestSession userRequestSession = this;
        synchronized (userRequestSession) {
            if (this.isClosed || this.aquireToken(task.getThreadPoolName())) {
                this.executeTask(qingContext, threadPoolName, task);
            } else {
                this.addBlockedTask(threadPoolName.name(), task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] invokeTask(QingServiceAsynDispatcherModel dispatcherModel, QingContext qingContext, Object service, boolean needWaitSomeTime, boolean forceLocal) throws InterruptedException, ExecutionException {
        ThreadPoolManage.QingThreadPoolName threadPoolName = this.getThreadPoolName(service, dispatcherModel.getMethodName());
        AsynServerRequestInvokeTask invokeTask = null;
        Future<Void> resultFuture = null;
        UserRequestSession userRequestSession = this;
        synchronized (userRequestSession) {
            if (this.isClosed) {
                AsynServerRequestInvokeTask invokeActionTask = TaskHelper.createInvokeTask(dispatcherModel, qingContext, service);
                this.executeTask(qingContext, threadPoolName, invokeActionTask);
                return null;
            }
            if (this.aquireToken(threadPoolName)) {
                invokeTask = this.createInvokeTask(dispatcherModel, qingContext, service);
                resultFuture = this.executeTask(qingContext, threadPoolName, invokeTask);
            } else if (forceLocal) {
                invokeTask = this.createInvokeTask(dispatcherModel, qingContext, service);
                invokeTask.setThreadPoolName(threadPoolName);
                invokeTask.setTaskId(UUID.randomUUID().toString());
                this.addBlockedTask(threadPoolName.name(), invokeTask);
            } else {
                RemoteSubmitState submitState = DistributeTaskMgr.getInstance().remoteExecuteTask(qingContext, dispatcherModel, threadPoolName);
                if (submitState != RemoteSubmitState.SUCCEED) {
                    invokeTask = this.createInvokeTask(dispatcherModel, qingContext, service);
                    invokeTask.setThreadPoolName(threadPoolName);
                    invokeTask.setTaskId(UUID.randomUUID().toString());
                    this.addBlockedTask(threadPoolName.name(), invokeTask);
                }
                return null;
            }
        }
        if (null != resultFuture && needWaitSomeTime) {
            try {
                resultFuture.get(3L, TimeUnit.SECONDS);
                return invokeTask.getResult();
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
        }
        return null;
    }

    private Future<Void> executeTask(QingContext qingContext, ThreadPoolManage.QingThreadPoolName threadPoolName, AsynServerRequestInvokeTask invokeTask) {
        try {
            return ThreadPoolManage.excuteThreadWithContext(threadPoolName, invokeTask, qingContext);
        }
        catch (Exception e) {
            this.onlyReleaseToken(threadPoolName);
            invokeTask.setResult(new ResponseErrorWrap(e));
            return null;
        }
    }

    public synchronized void refreshThreadMaxUsage(String threadPoolName, long avgCosts) {
        if (this.isClosed) {
            return;
        }
        long times = avgCosts / 5000L;
        long currentMaxUsage = (long)UserSessionMgr.THREAD_POOL_DEFAULT_MAX_USAGE - (long)UserSessionMgr.THREAD_POOL_MAX_USAGE_CHANGE_STEP_SIZE * times;
        LogUtil.info("task spent avg time:" + avgCosts + " ,thread poolName:" + threadPoolName + ", refresh new max usage:" + currentMaxUsage + " ,userId=" + this.userId);
        if (currentMaxUsage <= (long)UserSessionMgr.THREAD_POOL_DEFAULT_MIN_USAGE) {
            this.threadPoolMaxUsage.put(threadPoolName, UserSessionMgr.THREAD_POOL_DEFAULT_MIN_USAGE);
        } else {
            this.threadPoolMaxUsage.put(threadPoolName, (int)currentMaxUsage);
        }
    }

    private void onlyReleaseToken(ThreadPoolManage.QingThreadPoolName threadPoolName) {
        Integer currentSubmitted = this.tokenUsedCounts.get(threadPoolName.name());
        if (null != currentSubmitted && currentSubmitted > 0) {
            this.tokenUsedCounts.put(threadPoolName.name(), currentSubmitted - 1);
        }
    }

    public synchronized void releaseToken(ThreadPoolManage.QingThreadPoolName threadPoolName) {
        if (this.isClosed) {
            return;
        }
        this.touchMe();
        Integer currentSubmitted = this.tokenUsedCounts.get(threadPoolName.name());
        if (null != currentSubmitted && currentSubmitted > 0) {
            --this.totalTokenUsed;
            this.tokenUsedCounts.put(threadPoolName.name(), currentSubmitted - 1);
            this.wakeupWaitingTask(threadPoolName);
        }
    }

    private void wakeupWaitingTask(ThreadPoolManage.QingThreadPoolName threadPoolName) {
        LinkedList<AsynServerRequestInvokeTask> waitingTasks = this.threadWaitingTasks.get(threadPoolName.name());
        if (null != waitingTasks && waitingTasks.size() > 0) {
            ArrayList<AsynServerRequestInvokeTask> tasksToSubmitted = new ArrayList<AsynServerRequestInvokeTask>();
            for (int availableCounts = this.getAvailableTokenCounts(threadPoolName); availableCounts > 0; --availableCounts) {
                LogUtil.info("QingDistributeTask--waken up waiting task ,current availableCount:" + availableCounts + ",waiting task size:" + waitingTasks.size() + " ,userId=" + this.userId);
                AsynServerRequestInvokeTask taskToSubmit = waitingTasks.pollFirst();
                if (null == taskToSubmit) break;
                LogUtil.info("QingDistributeTask--invoke waiting task :" + taskToSubmit.getTaskDesc() + ",currentServer:" + DistributeTaskMgr.getInstance().getLocalIp() + " ,userId=" + this.userId);
                tasksToSubmitted.add(taskToSubmit);
            }
            Integer currentSubmitted = this.tokenUsedCounts.get(threadPoolName.name());
            this.tokenUsedCounts.put(threadPoolName.name(), currentSubmitted + tasksToSubmitted.size());
            for (AsynServerRequestInvokeTask taskToSubmit : tasksToSubmitted) {
                this.executeTask(taskToSubmit.getContext(), threadPoolName, taskToSubmit);
            }
        }
    }

    private int getAvailableTokenCounts(ThreadPoolManage.QingThreadPoolName threadPoolName) {
        String poolName = threadPoolName.name();
        Integer maxUsage = this.threadPoolMaxUsage.get(poolName);
        int maxLimit = (int)Math.ceil((double)(threadPoolName.getMaximumPoolSize() * maxUsage) / 100.0);
        Integer currentSubmitted = this.tokenUsedCounts.get(poolName);
        if (null == currentSubmitted) {
            return maxLimit;
        }
        return maxLimit - currentSubmitted;
    }

    private boolean aquireToken(ThreadPoolManage.QingThreadPoolName threadPoolName) {
        String poolName = threadPoolName.name();
        Integer maxUsage = null;
        maxUsage = this.threadPoolMaxUsage.get(poolName);
        if (null == maxUsage) {
            maxUsage = UserSessionMgr.THREAD_POOL_DEFAULT_MAX_USAGE;
            this.threadPoolMaxUsage.put(threadPoolName.name(), UserSessionMgr.THREAD_POOL_DEFAULT_MAX_USAGE);
        }
        int maxLimit = (int)Math.ceil((double)(threadPoolName.getMaximumPoolSize() * maxUsage) / 100.0);
        Integer currentSubmitted = this.tokenUsedCounts.get(poolName);
        if (null == currentSubmitted) {
            this.tokenUsedCounts.put(poolName, 1);
            ++this.totalTokenUsed;
            return true;
        }
        if (currentSubmitted < maxLimit) {
            this.tokenUsedCounts.put(poolName, currentSubmitted + 1);
            ++this.totalTokenUsed;
            return true;
        }
        return false;
    }

    public synchronized ReqInvokeStatistic getReqStatistic(String threadPoolName) {
        if (!this.reqStatisticMap.containsKey(threadPoolName)) {
            ReqInvokeStatistic reqInvokeStatistic = new ReqInvokeStatistic();
            this.reqStatisticMap.put(threadPoolName, reqInvokeStatistic);
        }
        return this.reqStatisticMap.get(threadPoolName);
    }

    @Override
    public boolean isNeedRemove() {
        return this.isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUpdate(CalcServerResource resource) {
        String longTaskThreadPoolName = ThreadPoolManage.QingThreadPoolName.QING_LONG_TIME_TASK_HANDLER.name();
        ThreadResourceStatus threadResourceStatus = resource.getThreadResourceStatus(longTaskThreadPoolName);
        Double remoteBlockSize = threadResourceStatus.getSessionBlockSize().get(this.sessionId);
        AbstractTaskChannel taskChannel = DistributeTaskMgr.getInstance().getTaskChannel(resource.getServerIp());
        if (null != taskChannel) {
            taskChannel.updateSessionBlockSize(this.sessionId, longTaskThreadPoolName, null == remoteBlockSize ? 0 : remoteBlockSize.intValue());
        }
        if (null != remoteBlockSize && remoteBlockSize > 0.0) {
            return;
        }
        int maxPoolSize = threadResourceStatus.getMaxSize();
        int currentSize = threadResourceStatus.getCurrentRunningSize();
        double ratio = (double)currentSize * 1.0 / (double)maxPoolSize;
        if (ratio >= 0.6) {
            return;
        }
        List<AsynServerRequestInvokeTask> tasksToInvokeByRemote = null;
        UserRequestSession userRequestSession = this;
        synchronized (userRequestSession) {
            LinkedList<AsynServerRequestInvokeTask> tasksBlocked = this.threadWaitingTasks.get(longTaskThreadPoolName);
            if (null == tasksBlocked || tasksBlocked.isEmpty()) {
                return;
            }
            int maxInvokeSize = SystemPropertyUtil.getInt("max.blocked.task.size.to.invoke.at.remote", 5);
            tasksToInvokeByRemote = this.popUpBlockedTask(maxInvokeSize, tasksBlocked, resource.getServerIp());
        }
        if (null != tasksToInvokeByRemote) {
            Iterator<AsynServerRequestInvokeTask> it = tasksToInvokeByRemote.iterator();
            while (it.hasNext()) {
                AsynServerRequestInvokeTask task = it.next();
                QingServiceAsynDispatcherModel dispatcherModel = task.getDispatcherModel();
                RemoteSubmitState submitState = DistributeTaskMgr.getInstance().directExecuteTask(task.getContext(), dispatcherModel, resource.getServerIp());
                if (submitState != RemoteSubmitState.SUCCEED) continue;
                LogUtil.info("QingDistributeTask-- blocked task submit to remote server: " + resource.getServerIp() + " succeed,task:" + task.getTaskDesc() + ",currentServer:" + DistributeTaskMgr.getInstance().getLocalIp() + " ,userId=" + this.userId);
                it.remove();
                task.getInvokeContext().setReqMigrated(true);
            }
            if (!tasksToInvokeByRemote.isEmpty()) {
                List<AsynServerRequestInvokeTask> failedSubmitTasks = tasksToInvokeByRemote;
                for (AsynServerRequestInvokeTask task : failedSubmitTasks) {
                    this.invokeDirect(task);
                }
            }
        }
    }

    private List<AsynServerRequestInvokeTask> popUpBlockedTask(int size, LinkedList<AsynServerRequestInvokeTask> tasksBlocked, String targetIp) {
        ArrayList<AsynServerRequestInvokeTask> tasksToDispatch = new ArrayList<AsynServerRequestInvokeTask>();
        Iterator iterator = tasksBlocked.iterator();
        int total = 0;
        while (iterator.hasNext() && total < size) {
            long blockedTime;
            boolean bExisted;
            boolean isFromOriginalServer;
            AsynServerRequestInvokeTask task = (AsynServerRequestInvokeTask)iterator.next();
            if (task.isNeedInvokeLocal() || (isFromOriginalServer = targetIp.equals(task.getSourceServer())) || (bExisted = task.getDispatcherModel().isInPreDispatchPaths(targetIp)) && (blockedTime = System.currentTimeMillis() - task.getBlockBeginTime()) < 3000L) continue;
            tasksToDispatch.add(task);
            iterator.remove();
            ++total;
        }
        return tasksToDispatch;
    }

    public static class ReqInvokeStatistic {
        private static final int RESERVED_SIZE = 50;
        private volatile long avgCostsMs = 0L;
        private List<Long> recentInvokeCosts = new LinkedList<Long>();
        private long recentActiveTime = -1L;

        public synchronized void refreshAvgCosts(long msTime) {
            long idleTime;
            long currentTime = System.currentTimeMillis();
            if (-1L != this.recentActiveTime && (idleTime = currentTime - this.recentActiveTime) >= 30000L) {
                this.recentInvokeCosts.clear();
                this.avgCostsMs = msTime;
                this.recentInvokeCosts.add(msTime);
                this.recentActiveTime = currentTime;
                return;
            }
            this.recentActiveTime = currentTime;
            int originalSize = this.recentInvokeCosts.size();
            long removedFirstCosts = 0L;
            if (originalSize >= 50) {
                removedFirstCosts = this.recentInvokeCosts.remove(0);
            }
            this.recentInvokeCosts.add(msTime);
            long totalSpents = this.avgCostsMs * (long)originalSize - removedFirstCosts;
            this.avgCostsMs = (totalSpents += msTime) / (long)this.recentInvokeCosts.size();
        }

        public long getAvgCostsMs() {
            return this.avgCostsMs;
        }
    }
}

