/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.distribute.session;

import com.kingdee.bos.qing.common.distribute.resource.ServerResourceMgr;
import com.kingdee.bos.qing.common.distribute.session.UserRequestSession;
import com.kingdee.bos.qing.common.thread.DelayedRunnable;
import com.kingdee.bos.qing.common.thread.GlobalScheduledExecutor;
import com.kingdee.bos.qing.util.SystemPropertyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class UserSessionMgr
implements DelayedRunnable {
    private static final int MAX_SESSION_CACHE_SIZE = SystemPropertyUtil.getInt("qing.user.session.max.cache.size", 1000);
    public static final int THREAD_POOL_MAX_USAGE_CHANGE_STEP_SIZE = SystemPropertyUtil.getInt("qing.threadpool.maxusage.change.step.size", 4);
    public static final int THREAD_POOL_DEFAULT_MAX_USAGE = SystemPropertyUtil.getInt("qing.threadpool.default.maxusage", 20);
    public static final int THREAD_POOL_DEFAULT_MIN_USAGE = SystemPropertyUtil.getInt("qing.threadpool.default.minusage", 4);
    private static final UserSessionMgr instance = new UserSessionMgr();
    private Map<String, UserRequestSession> sessionMap = new HashMap<String, UserRequestSession>(10);

    private UserSessionMgr() {
        GlobalScheduledExecutor.schedule(this);
    }

    public static UserSessionMgr getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserRequestSession getOrCreateReqSession(String sessionId, String userId) {
        Map<String, UserRequestSession> map = this.sessionMap;
        synchronized (map) {
            UserRequestSession reqSession = this.sessionMap.get(sessionId);
            if (null == reqSession) {
                if (this.sessionMap.size() >= MAX_SESSION_CACHE_SIZE) {
                    Iterator<Map.Entry<String, UserRequestSession>> it = this.sessionMap.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<String, UserRequestSession> entry = it.next();
                        UserRequestSession tmp = entry.getValue();
                        long unAliveTime = System.currentTimeMillis() - tmp.getTouchTime();
                        if (unAliveTime < 10000L || !tmp.closeIfNotBusy()) continue;
                        it.remove();
                        break;
                    }
                }
                reqSession = new UserRequestSession(sessionId, userId);
                this.sessionMap.put(sessionId, reqSession);
            } else {
                reqSession.touchMe();
            }
            return reqSession;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Double> getSessionBlockSize(String threadPoolName) {
        HashSet<UserRequestSession> tempSessions = new HashSet<UserRequestSession>(10);
        Map<String, UserRequestSession> map = this.sessionMap;
        synchronized (map) {
            tempSessions.addAll(this.sessionMap.values());
        }
        HashMap<String, Double> sessionBlockSize = new HashMap<String, Double>(10);
        for (UserRequestSession requestSession : tempSessions) {
            int blockSize = requestSession.getBlockSize(threadPoolName);
            if (blockSize <= 0) continue;
            sessionBlockSize.put(requestSession.getSessionId(), Double.valueOf(blockSize));
        }
        return sessionBlockSize;
    }

    @Override
    public long getDelayTime() {
        return 60000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<UserRequestSession> deletedSessions = new ArrayList<UserRequestSession>(3);
        Map<String, UserRequestSession> map = this.sessionMap;
        synchronized (map) {
            Iterator<Map.Entry<String, UserRequestSession>> iterator = this.sessionMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, UserRequestSession> entry = iterator.next();
                UserRequestSession requestSession = entry.getValue();
                if (!requestSession.isCanDel()) continue;
                iterator.remove();
                deletedSessions.add(requestSession);
            }
        }
        for (UserRequestSession session : deletedSessions) {
            ServerResourceMgr.getInstance().removeResourceChangeListener(session);
        }
        GlobalScheduledExecutor.schedule(this);
    }
}

