/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.distribute.task;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.distribute.exception.TaskTransportException;
import com.kingdee.bos.qing.common.distribute.resource.ServerResourceMgr;
import com.kingdee.bos.qing.common.distribute.task.DistributeTaskMgr;
import com.kingdee.bos.qing.common.distribute.task.RemoteSubmitState;
import com.kingdee.bos.qing.common.distribute.task.RemoteTaskRecorder;
import com.kingdee.bos.qing.common.distribute.task.TaskEvent;
import com.kingdee.bos.qing.common.distribute.task.TaskResponse;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractTaskChannel {
    private String targetIp;
    protected AtomicBoolean isAvailable = new AtomicBoolean(false);
    protected Map<String, RemoteTaskRecorder> taskRecorderMap = new HashMap<String, RemoteTaskRecorder>(10);

    public AbstractTaskChannel(String targetIp) {
        this.targetIp = targetIp;
    }

    public String getTargetIp() {
        return this.targetIp;
    }

    public RemoteSubmitState publishTask(QingContext qingContext, TaskEvent taskEvent) throws TaskTransportException {
        if (!this.isAvailable.get()) {
            return RemoteSubmitState.ERR_SUBMIT_FAILED;
        }
        this.internalPublish(qingContext, taskEvent);
        return RemoteSubmitState.SUCCEED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RemoteTaskRecorder getOrCreateTaskRecorder(String sessionId, boolean createIfNotExist) {
        Map<String, RemoteTaskRecorder> map = this.taskRecorderMap;
        synchronized (map) {
            RemoteTaskRecorder taskRecorder = this.taskRecorderMap.get(sessionId);
            if (null == taskRecorder && createIfNotExist) {
                taskRecorder = new RemoteTaskRecorder(sessionId);
                this.taskRecorderMap.put(sessionId, taskRecorder);
            }
            return taskRecorder;
        }
    }

    public void updateSessionBlockSize(String sessionId, String threadPoolName, int blockSize) {
        RemoteTaskRecorder taskRecorder = this.getOrCreateTaskRecorder(sessionId, false);
        if (null != taskRecorder) {
            taskRecorder.updateThreadBlockSize(threadPoolName, blockSize);
        }
    }

    protected abstract void internalPublish(QingContext var1, TaskEvent var2) throws TaskTransportException;

    public abstract boolean tryAbandonTask(String var1, String var2);

    public abstract boolean isAvailable();

    public void receiveTaskResponse(String taskId, TaskResponse response) {
        RemoteTaskRecorder taskRecorder = this.getOrCreateTaskRecorder(response.getSessionId(), false);
        if (null == taskRecorder) {
            return;
        }
        switch (response.getStateCode()) {
            case 0: {
                LogUtil.info("QingDistributeTask--task is submitted in remote server,taskId=" + taskId + ",remote server=" + this.getTargetIp() + ",currentServer:" + DistributeTaskMgr.getInstance().getLocalIp());
                taskRecorder.updateBlockSize(response);
                break;
            }
            case 3: {
                LogUtil.info("QingDistributeTask--task is blocked in remote server,taskId=" + taskId + ",remote server=" + this.getTargetIp() + ",currentServer:" + DistributeTaskMgr.getInstance().getLocalIp());
                taskRecorder.updateBlockSize(response);
                break;
            }
            case 1: {
                LogUtil.info("QingDistributeTask--remote server begin execute task,taskId=" + taskId + ",remote server=" + this.getTargetIp() + ",currentServer:" + DistributeTaskMgr.getInstance().getLocalIp());
                taskRecorder.updateBeginningTask(taskId, response);
                break;
            }
            case 2: {
                LogUtil.info("QingDistributeTask--remote task finished in server:" + response.getRemoteServer() + ", taskId=" + taskId);
                taskRecorder.updateFinishedTask(taskId);
            }
        }
        ServerResourceMgr.getInstance().updateServerResource(this.getTargetIp(), response.getThreadPoolName(), response.getCurrentRunningSize());
    }

    public long selectRecentRemoteCosts(String sessionId, String threadPoolName) {
        RemoteTaskRecorder taskRecorder = this.getOrCreateTaskRecorder(sessionId, false);
        if (null == taskRecorder) {
            return -1L;
        }
        return taskRecorder.getRecentTaskCosts(threadPoolName);
    }

    public boolean isRecentBlockExist(String sessionId, String threadPoolName) {
        RemoteTaskRecorder taskRecorder = this.getOrCreateTaskRecorder(sessionId, false);
        if (null == taskRecorder) {
            return false;
        }
        return taskRecorder.isRecentBlockedExist(threadPoolName);
    }

    public void sendTaskResponse(TaskEvent taskEvent) throws TaskTransportException {
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaskEvent> getUnExecuteTasks() {
        ArrayList<TaskEvent> taskEvents = new ArrayList<TaskEvent>(5);
        Map<String, RemoteTaskRecorder> map = this.taskRecorderMap;
        synchronized (map) {
            for (RemoteTaskRecorder taskRecorder : this.taskRecorderMap.values()) {
                taskEvents.addAll(taskRecorder.getUnExecuteTasks());
            }
            return taskEvents;
        }
    }
}

