/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.distribute.zk.lock;

import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.lock.QingLockRequireException;
import com.kingdee.bos.qing.common.lock.ZkClientSendTreadDeadException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryLoop;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.WatcherRemoveCuratorFramework;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.recipes.locks.LockInternalsDriver;
import org.apache.curator.framework.recipes.locks.LockInternalsSorter;
import org.apache.curator.framework.recipes.locks.PredicateResults;
import org.apache.curator.utils.PathUtils;
import org.apache.curator.utils.ThreadUtils;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;

class ZkInternalLock {
    private final WatcherRemoveCuratorFramework client;
    private final String path;
    private final String basePath;
    private final LockInternalsDriver driver;
    private final String lockName;
    private static final Executor executor = Executors.newSingleThreadExecutor();
    private final Watcher watcher = new Watcher(){

        public void process(WatchedEvent event) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    ZkInternalLock.this.notifyFromWather();
                }
            });
        }
    };
    private volatile int maxLeases;

    public void clean() throws AbstractQingException {
        try {
            this.client.delete().forPath(this.basePath);
        }
        catch (KeeperException.BadVersionException badVersionException) {
        }
        catch (KeeperException.NotEmptyException notEmptyException) {
        }
        catch (Exception e) {
            throw new QingLockRequireException(e.getMessage(), e);
        }
    }

    ZkInternalLock(CuratorFramework client, LockInternalsDriver driver, String path, String lockName, int maxLeases) {
        this.driver = driver;
        this.lockName = lockName;
        this.maxLeases = maxLeases;
        this.client = client.newWatcherRemoveCuratorFramework();
        this.basePath = PathUtils.validatePath((String)path);
        this.path = ZKPaths.makePath((String)path, (String)lockName);
    }

    synchronized void setMaxLeases(int maxLeases) {
        this.maxLeases = maxLeases;
        this.notifyAll();
    }

    final void releaseLock(String lockPath) throws AbstractQingException {
        this.client.removeWatchers();
        this.deleteOurPath(lockPath);
    }

    CuratorFramework getClient() {
        return this.client;
    }

    public static List<String> getSortedChildren(CuratorFramework client, String basePath, final String lockName, final LockInternalsSorter sorter) throws AbstractQingException {
        try {
            List children = (List)client.getChildren().forPath(basePath);
            ArrayList<String> sortedList = new ArrayList<String>(children);
            Collections.sort(sortedList, new Comparator<String>(){

                @Override
                public int compare(String lhs, String rhs) {
                    return sorter.fixForSorting(lhs, lockName).compareTo(sorter.fixForSorting(rhs, lockName));
                }
            });
            return sortedList;
        }
        catch (KeeperException.NoNodeException ignore) {
            return Collections.emptyList();
        }
        catch (Exception e) {
            throw new QingLockRequireException(e.getMessage(), e);
        }
    }

    List<String> getSortedChildren() throws AbstractQingException {
        return ZkInternalLock.getSortedChildren((CuratorFramework)this.client, this.basePath, this.lockName, (LockInternalsSorter)this.driver);
    }

    String getLockName() {
        return this.lockName;
    }

    LockInternalsDriver getDriver() {
        return this.driver;
    }

    String attemptLock(long time, TimeUnit unit, byte[] lockNodeBytes) throws AbstractQingException {
        long startMillis = System.currentTimeMillis();
        Long millisToWait = unit != null ? Long.valueOf(unit.toMillis(time)) : null;
        byte[] localLockNodeBytes = lockNodeBytes;
        int retryCount = 0;
        String ourPath = null;
        boolean hasTheLock = false;
        boolean isDone = false;
        while (!isDone) {
            isDone = true;
            try {
                ourPath = this.driver.createsTheLock((CuratorFramework)this.client, this.path, localLockNodeBytes);
                hasTheLock = this.internalLockLoop(startMillis, millisToWait, ourPath);
            }
            catch (KeeperException.NoNodeException e) {
                if (this.client.getZookeeperClient().getRetryPolicy().allowRetry(retryCount++, System.currentTimeMillis() - startMillis, RetryLoop.getDefaultRetrySleeper())) {
                    isDone = false;
                    continue;
                }
                throw new QingLockRequireException(e.getMessage(), e);
            }
            catch (InterruptedException e) {
                String errMsg = e.getMessage().toLowerCase();
                if (errMsg.contains("sendthread is not alive") || errMsg.contains("is not alive")) {
                    throw new ZkClientSendTreadDeadException("", e);
                }
                throw new QingLockRequireException(e.getMessage(), e);
            }
            catch (Exception e) {
                throw new QingLockRequireException(e.getMessage(), e);
            }
        }
        if (hasTheLock) {
            return ourPath;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean internalLockLoop(long startMillis, Long millisToWait, String ourPath) throws AbstractQingException, KeeperException.NoNodeException {
        boolean haveTheLock = false;
        boolean doDelete = false;
        try {
            while (this.client.getState() == CuratorFrameworkState.STARTED) {
                String sequenceNodeName;
                if (haveTheLock) return haveTheLock;
                List<String> children = this.getSortedChildren();
                PredicateResults predicateResults = this.driver.getsTheLock((CuratorFramework)this.client, children, sequenceNodeName = ourPath.substring(this.basePath.length() + 1), this.maxLeases);
                if (predicateResults.getsTheLock()) {
                    haveTheLock = true;
                    continue;
                }
                String previousSequencePath = this.basePath + "/" + predicateResults.getPathToWatch();
                ZkInternalLock zkInternalLock = this;
                synchronized (zkInternalLock) {
                    try {
                        ((BackgroundPathable)this.client.getData().usingWatcher(this.watcher)).forPath(previousSequencePath);
                        if (millisToWait != null) {
                            millisToWait = millisToWait - (System.currentTimeMillis() - startMillis);
                            startMillis = System.currentTimeMillis();
                            if (millisToWait <= 0L) {
                                doDelete = true;
                                return haveTheLock;
                            }
                            this.wait(millisToWait);
                        } else {
                            this.wait();
                        }
                    }
                    catch (KeeperException.NoNodeException noNodeException) {
                        // empty catch block
                    }
                }
            }
            return haveTheLock;
        }
        catch (KeeperException.NoNodeException e) {
            throw e;
        }
        catch (Exception e) {
            ThreadUtils.checkInterrupted((Throwable)e);
            doDelete = true;
            throw new QingLockRequireException(e.getMessage(), e);
        }
        finally {
            if (doDelete) {
                this.deleteOurPath(ourPath);
            }
        }
    }

    private synchronized void notifyFromWather() {
        this.notifyAll();
    }

    private void deleteOurPath(String ourPath) throws AbstractQingException {
        try {
            ((ChildrenDeletable)this.client.delete().guaranteed()).forPath(ourPath);
        }
        catch (KeeperException.NoNodeException noNodeException) {
        }
        catch (Exception e) {
            throw new QingLockRequireException(e.getMessage(), e);
        }
    }
}

