/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.framework.manage;

import com.kingdee.bos.qing.common.framework.manage.AbstractClientCache;
import com.kingdee.bos.qing.common.framework.model.server.ServerChannelMessage;
import com.kingdee.bos.qing.common.session.IGlobalQingSession;
import java.util.concurrent.TimeUnit;

public class ServerChannelManager
extends AbstractClientCache {
    private static final String CALL_ID_SET_KEY = "CallID.Set";

    public static String[] getServerChannelCallIDsValue(String clientID) {
        IGlobalQingSession globalQingSession = ServerChannelManager.getGlobalQingSession();
        String cacheKey = ServerChannelManager.getCallIDSetKey(clientID);
        return globalQingSession.getSetValues(cacheKey);
    }

    public static void removeCallID(String clientID, String[] callIds) {
        IGlobalQingSession globalQingSession = ServerChannelManager.getGlobalQingSession();
        String cacheKey = ServerChannelManager.getCallIDSetKey(clientID);
        globalQingSession.removeSetValue(cacheKey, callIds);
    }

    public static void addCallID(String clientID, String[] callIds) {
        IGlobalQingSession globalQingSession = ServerChannelManager.getGlobalQingSession();
        String cacheKey = ServerChannelManager.getCallIDSetKey(clientID);
        globalQingSession.addToSet(cacheKey, callIds, 1, TimeUnit.HOURS);
    }

    public static ServerChannelMessage getChannelMessage(String clientID, String clientChannelCallID) {
        IGlobalQingSession globalQingSession = ServerChannelManager.getGlobalQingSession();
        String cacheKey = ServerChannelManager.getCacheKey(clientID);
        return globalQingSession.hGetCache(cacheKey, ServerChannelMessage.getCacheKey(clientChannelCallID), ServerChannelMessage.class);
    }

    public static void saveChannelMessage(ServerChannelMessage channelMessage) {
        String cacheKey = ServerChannelManager.getCacheKey(channelMessage.getClientID());
        IGlobalQingSession globalQingSession = ServerChannelManager.getGlobalQingSession();
        globalQingSession.hSetCache(cacheKey, channelMessage);
    }

    public static void clearServerChannels(String clientID) {
        String cacheKey = ServerChannelManager.getCacheKey(clientID);
        IGlobalQingSession globalQingSession = ServerChannelManager.getGlobalQingSession();
        globalQingSession.remove(ServerChannelManager.getCallIDSetKey(clientID));
        globalQingSession.remove(cacheKey);
    }

    private static String getCallIDSetKey(String clientID) {
        return clientID + CALL_ID_SET_KEY;
    }
}

