/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.framework.server.annotation;

import com.kingdee.bos.qing.common.framework.server.annotation.IServiceClassAnnotationHandler;
import com.kingdee.bos.qing.common.framework.server.annotation.IServiceMethodAnnotationHandler;
import com.kingdee.bos.qing.common.framework.server.annotation.iotask.IOTaskServiceClassAnnotation;
import com.kingdee.bos.qing.common.framework.server.annotation.iotask.IOTaskServiceClassAnnotationHandler;
import com.kingdee.bos.qing.common.framework.server.annotation.iotask.IOTaskServiceMethodAnnotation;
import com.kingdee.bos.qing.common.framework.server.annotation.iotask.IOTaskServiceMethodAnnotationHandler;
import com.kingdee.bos.qing.common.framework.server.annotation.longtime.LongTimeServiceClassAnnotation;
import com.kingdee.bos.qing.common.framework.server.annotation.longtime.LongTimeServiceClassAnnotationHandler;
import com.kingdee.bos.qing.common.framework.server.annotation.longtime.LongTimeServiceMethodAnnotation;
import com.kingdee.bos.qing.common.framework.server.annotation.longtime.LongTimeServiceMethodAnnotationHandler;
import com.kingdee.bos.qing.common.framework.server.annotation.rptexec.RptExecServiceClassAnnotation;
import com.kingdee.bos.qing.common.framework.server.annotation.rptexec.RptExecServiceClassAnnotationHandler;
import com.kingdee.bos.qing.common.framework.server.annotation.rptexec.RptExecServiceMethodAnnotation;
import com.kingdee.bos.qing.common.framework.server.annotation.rptexec.RptExecServiceMethodAnnotationHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class ServiceAnnotationUtil {
    private static Map<Class<? extends Annotation>, IServiceClassAnnotationHandler<? extends Annotation>> serviceClassAnnotationHandlerMap = new HashMap<Class<? extends Annotation>, IServiceClassAnnotationHandler<? extends Annotation>>();
    private static Map<Class<? extends Annotation>, IServiceMethodAnnotationHandler<? extends Annotation>> serviceMethodAnnotationHandlerMap = new HashMap<Class<? extends Annotation>, IServiceMethodAnnotationHandler<? extends Annotation>>();

    public static void handlerClassAnnotation(Class<?> serviceClass) {
        while (!"java.lang.Object".equals(serviceClass.getName())) {
            Annotation[] annotations = serviceClass.getAnnotations();
            if (annotations != null) {
                for (Annotation annotation : annotations) {
                    Class<? extends Annotation> annotationClass = annotation.annotationType();
                    IServiceClassAnnotationHandler<? extends Annotation> serviceClassAnnotationHandler = serviceClassAnnotationHandlerMap.get(annotationClass);
                    if (serviceClassAnnotationHandler == null) continue;
                    serviceClassAnnotationHandler.handler(annotation, serviceClass);
                }
            }
            ServiceAnnotationUtil.handlerInterfaceClassAnnotation(serviceClass);
            ServiceAnnotationUtil.handlMethodAnnotation(serviceClass);
            serviceClass = serviceClass.getSuperclass();
        }
    }

    private static void handlerInterfaceClassAnnotation(Class<?> serviceClass) {
        Class<?>[] interfaces = serviceClass.getInterfaces();
        if (interfaces != null) {
            for (Class<?> interfaceClass : interfaces) {
                Annotation[] annotations = interfaceClass.getAnnotations();
                if (annotations == null) continue;
                for (Annotation annotation : annotations) {
                    Class<? extends Annotation> annotationClass = annotation.annotationType();
                    IServiceClassAnnotationHandler<? extends Annotation> serviceClassAnnotationHandler = serviceClassAnnotationHandlerMap.get(annotationClass);
                    if (serviceClassAnnotationHandler == null) continue;
                    serviceClassAnnotationHandler.handler(annotation, serviceClass);
                }
            }
        }
    }

    public static void handlMethodAnnotation(Class<?> serviceClass) {
        Method[] methods = serviceClass.getMethods();
        Annotation[] annotations = null;
        if (methods != null) {
            for (Method method : methods) {
                annotations = method.getAnnotations();
                if (annotations == null) continue;
                for (Annotation annotation : annotations) {
                    Class<? extends Annotation> annotationClass = annotation.annotationType();
                    IServiceMethodAnnotationHandler<? extends Annotation> serviceMethodAnnotationHandler = serviceMethodAnnotationHandlerMap.get(annotationClass);
                    if (serviceMethodAnnotationHandler == null) continue;
                    serviceMethodAnnotationHandler.handler(annotation, serviceClass, method);
                }
            }
        }
    }

    static {
        serviceClassAnnotationHandlerMap.put(LongTimeServiceClassAnnotation.class, new LongTimeServiceClassAnnotationHandler());
        serviceMethodAnnotationHandlerMap.put(LongTimeServiceMethodAnnotation.class, new LongTimeServiceMethodAnnotationHandler());
        serviceClassAnnotationHandlerMap.put(RptExecServiceClassAnnotation.class, new RptExecServiceClassAnnotationHandler());
        serviceMethodAnnotationHandlerMap.put(RptExecServiceMethodAnnotation.class, new RptExecServiceMethodAnnotationHandler());
        serviceClassAnnotationHandlerMap.put(IOTaskServiceClassAnnotation.class, new IOTaskServiceClassAnnotationHandler());
        serviceMethodAnnotationHandlerMap.put(IOTaskServiceMethodAnnotation.class, new IOTaskServiceMethodAnnotationHandler());
    }
}

