/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.framework.web;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.common.framework.manage.ClientManager;
import com.kingdee.bos.qing.common.framework.model.client.AbstractClientMessage;
import com.kingdee.bos.qing.common.framework.model.client.ClientRemoteCallMessage;
import com.kingdee.bos.qing.common.framework.web.ClientMessageHandler;
import com.kingdee.bos.qing.common.framework.web.ServerFileAccesser;
import com.kingdee.bos.qing.common.framework.web.polling.ServerMessageSender4Polling;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.network.blacklist.IpBlackList;
import com.kingdee.bos.qing.common.session.IGlobalQingSession;
import com.kingdee.bos.qing.common.session.IQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.DynamicFileTypeEnum;
import com.kingdee.bos.qing.filesystem.manager.model.FileTypeUtil;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.resource.exception.UploadFileException;
import com.kingdee.bos.qing.response.ResponseUtil;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.HttpUtil;
import com.kingdee.bos.qing.util.IOUtil;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.URLUtil;
import com.kingdee.bos.qing.util.ZipUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public abstract class AbstractQingAction {
    public static final String LASTREQUESTCOOKIES = "lastRequestCookies";
    private static final Pattern HTTP_HEADER_FILENAME_PATTERN = Pattern.compile("[\\w-_.%]*");
    private static final String ERROR_CODE = "errorCode";
    private static final String ERROR_MESSAGE = "errorMessage";
    private static final String CLIENT_ID = "clientID";
    private static final String APP_ID = "appID";
    private static final String PAGE_ID = "pageId";
    private static final String SAFETY_CODE = "safetyCode";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String USER_AGENT = "User-Agent";
    private static final String UTF_8 = "UTF-8";
    private static final String FILE_NAME = "fileName";
    private static final String EXPORT_KEY_PREFIX = "Qing.Export.";

    protected final void handlerExceptionWithErrorURL(HttpServletRequest request, HttpServletResponse response, String errorURL, Throwable e) {
        this.doLogException(e);
        try {
            String title = Messages.getMLS("errorPage", "\u9519\u8bef\u754c\u9762", Messages.ProjectName.QING_COMMON);
            ISafetyURL safetyURL = this.createSafetyURL(request, title, errorURL);
            if (!(e instanceof AbstractQingException)) {
                e = new IntegratedRuntimeException(e);
            }
            safetyURL.appendParamToUrl(ERROR_CODE, "" + ((AbstractQingException)e).getErrorCode());
            safetyURL.appendParamToUrl(ERROR_MESSAGE, e.getMessage());
            safetyURL.sendRedirect(response);
        }
        catch (IOException e1) {
            LogUtil.error(e1.getMessage(), e1);
        }
    }

    protected final void handlerException(HttpServletRequest request, HttpServletResponse response, Throwable e) {
        this.doLogException(e);
        try {
            String errorURL = this.getQingErrorUrl();
            String title = Messages.getMLS("errorPage", "\u9519\u8bef\u754c\u9762", Messages.ProjectName.QING_COMMON);
            ISafetyURL safetyURL = this.createSafetyURL(request, title, errorURL);
            if (!(e instanceof AbstractQingException)) {
                e = new IntegratedRuntimeException(e);
            }
            safetyURL.appendParamToUrl(ERROR_CODE, "" + ((AbstractQingException)e).getErrorCode());
            safetyURL.appendParamToUrl(ERROR_MESSAGE, e.getMessage());
            safetyURL.sendRedirect(response);
        }
        catch (IOException e1) {
            LogUtil.error(e1.getMessage(), e1);
        }
    }

    protected final void handlerError(HttpServletRequest request, HttpServletResponse response, String errorCode) {
        try {
            String errorURL = this.getQingErrorUrl();
            String title = Messages.getMLS("errorPage", "\u9519\u8bef\u754c\u9762", Messages.ProjectName.QING_COMMON);
            ISafetyURL safetyURL = this.createSafetyURL(request, title, errorURL);
            safetyURL.appendParamToUrl(ERROR_CODE, "" + errorCode);
            safetyURL.sendRedirect(response);
        }
        catch (IOException e1) {
            LogUtil.error(e1.getMessage(), e1);
        }
    }

    protected final void handlerError(HttpServletRequest request, HttpServletResponse response, String errorCode, String errorMessage) {
        try {
            String errorURL = this.getQingErrorUrl();
            String title = Messages.getMLS("errorPage", "\u9519\u8bef\u754c\u9762", Messages.ProjectName.QING_COMMON);
            ISafetyURL safetyURL = this.createSafetyURL(request, title, errorURL);
            safetyURL.appendParamToUrl(ERROR_CODE, errorCode);
            safetyURL.appendParamToUrl(ERROR_MESSAGE, errorMessage);
            safetyURL.sendRedirect(response);
        }
        catch (IOException e1) {
            LogUtil.error(e1.getMessage(), e1);
        }
    }

    protected final void handlerExceptionForClosable(HttpServletRequest request, HttpServletResponse response, Throwable e) {
        this.doLogException(e);
        try {
            String errorURL = this.getQingClosableErrorUrl();
            String title = Messages.getMLS("errorPage", "\u9519\u8bef\u754c\u9762", Messages.ProjectName.QING_COMMON);
            ISafetyURL safetyURL = this.createSafetyURL(request, title, errorURL);
            if (!(e instanceof AbstractQingException)) {
                e = new IntegratedRuntimeException(e);
            }
            safetyURL.appendParamToUrl(ERROR_CODE, "" + ((AbstractQingException)e).getErrorCode());
            safetyURL.appendParamToUrl(ERROR_MESSAGE, e.getMessage());
            safetyURL.sendRedirect(response);
        }
        catch (IOException e1) {
            LogUtil.error(e1.getMessage(), e1);
        }
    }

    protected abstract String getQingErrorUrl();

    protected abstract String getQingClosableErrorUrl();

    protected abstract ISafetyURL createSafetyURL(HttpServletRequest var1, String var2, String var3);

    protected abstract IQingSession getQingSession(HttpServletRequest var1);

    protected abstract void dispatcherToUrl(HttpServletRequest var1, HttpServletResponse var2, String var3) throws IOException;

    protected void protectedSafetyUrl(HttpServletRequest request, HttpServletResponse response, QingContext qingContext) throws IOException {
        String safetyCode = request.getParameter(SAFETY_CODE);
        String queryString = request.getQueryString();
        String clientID = request.getParameter(CLIENT_ID);
        String appID = request.getParameter(APP_ID);
        try {
            String targetURL = ClientManager.getTargetURL(qingContext, clientID, safetyCode, queryString);
            if (targetURL == null) {
                this.handlerError(request, response, "illegalURLRequest");
            } else if (ClientManager.isNewOpenClient(clientID)) {
                this.dispatcherToUrl(request, response, targetURL);
            } else {
                String title = ClientManager.getAttribute(clientID, "Title");
                String safetyURL = ClientManager.getAttribute(clientID, "SafetyURL");
                SafetyURL newSafetyURL = new SafetyURL(qingContext, appID, title, safetyURL, targetURL);
                newSafetyURL.sendRedirect(response);
            }
        }
        catch (Exception e) {
            LogUtil.error(e.getMessage(), e);
            this.handlerError(request, response, "illegalURLRequest");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void protectedDoPolling(HttpServletRequest request, IQingSession qingSession, QingContext qingContext, HttpServletResponse response) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ServletInputStream servletInputStream = null;
        String messageContent = null;
        try {
            servletInputStream = request.getInputStream();
            IOUtil.copy((InputStream)request.getInputStream(), outputStream);
            messageContent = outputStream.toString();
        }
        catch (Throwable throwable) {
            CloseUtil.close(new Closeable[]{outputStream, servletInputStream});
            outputStream = null;
            servletInputStream = null;
            throw throwable;
        }
        CloseUtil.close(new Closeable[]{outputStream, servletInputStream});
        outputStream = null;
        servletInputStream = null;
        List messages = JsonUtil.decodeFromString(messageContent, List.class);
        ArrayList<AbstractClientMessage> clientMessages = new ArrayList<AbstractClientMessage>();
        String cookiesString = null;
        if (messages != null && !messages.isEmpty()) {
            for (String message : messages) {
                AbstractClientMessage clientMessage = AbstractClientMessage.edcode(message);
                if (clientMessage != null) {
                    clientMessages.add(clientMessage);
                }
                if (!(clientMessage instanceof ClientRemoteCallMessage)) continue;
                if (cookiesString == null) {
                    Cookie[] cookies = request.getCookies();
                    cookiesString = "";
                    if (cookies != null) {
                        StringBuilder cookiesStringBuilder = new StringBuilder();
                        for (Cookie cookie : cookies) {
                            cookiesStringBuilder.append(cookie.getName());
                            cookiesStringBuilder.append("=");
                            cookiesStringBuilder.append(cookie.getValue());
                            cookiesStringBuilder.append(";");
                        }
                        if (cookiesStringBuilder.length() > 0) {
                            cookiesString = cookiesStringBuilder.toString();
                        }
                    }
                }
                ClientRemoteCallMessage clientRemoteCallMessage = (ClientRemoteCallMessage)clientMessage;
                clientRemoteCallMessage.getParams().put(LASTREQUESTCOOKIES, cookiesString);
            }
        }
        if (clientMessages.isEmpty()) {
            return;
        }
        QingSessionUtil.setQingSessionImpl(qingSession);
        ServerMessageSender4Polling messageListener = new ServerMessageSender4Polling();
        ClientMessageHandler.handle(qingContext, messageListener, clientMessages);
        byte[] result = messageListener.packMessages();
        AbstractQingAction.writeSuccessJsonResponse(result, response, true);
    }

    protected static void protectedLoadImg(QingContext qingContext, String appID, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String fileName = request.getParameter(FILE_NAME);
        response.setHeader(CONTENT_TYPE, "application/octet-stream");
        if (StringUtils.isNotEmpty(fileName)) {
            try {
                fileName = URLEncoder.encode(fileName, UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                LogUtil.error(e.getMessage(), e);
                fileName = System.currentTimeMillis() + "";
            }
            String fileType = request.getParameter("fileType");
            AbstractQingFileType qingFileType = FileTypeUtil.getInstanceBySubFolder(fileType);
            response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
            ServerFileAccesser.loadFile(qingContext, appID, fileName, qingFileType, (OutputStream)response.getOutputStream());
        } else {
            String fullPath = request.getParameter("fullPath");
            String[] arrParam = fullPath.split("/");
            response.setHeader("Content-Disposition", "attachment; filename=" + arrParam[arrParam.length - 1]);
            ServerFileAccesser.loadImgByFullPath(qingContext, appID, fullPath, (OutputStream)response.getOutputStream());
        }
    }

    protected static void loadFontLibCss(QingContext qingContext, String appID, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setHeader("accept-ranges", "bytes");
        response.setHeader(CONTENT_TYPE, "text/css");
        response.setHeader("Content-Disposition", "attachment; fileName= fontLib.css");
        AbstractQingAction.loadFile(qingContext, appID, response, DynamicFileTypeEnum.CSS, "");
    }

    protected static void loadFontLibJs(QingContext qingContext, String appID, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setHeader("accept-ranges", "bytes");
        response.setHeader(CONTENT_TYPE, "application/javascript");
        response.setHeader("Content-Disposition", "attachment; fileName= fontLib.js");
        AbstractQingAction.loadFile(qingContext, appID, response, DynamicFileTypeEnum.JS, "");
    }

    protected static void loadFontFile(QingContext qingContext, String appID, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String fileName = request.getParameter(FILE_NAME);
        if (fileName != null) {
            try {
                fileName = URLEncoder.encode(fileName, UTF_8);
                Matcher fileNameMatcher = HTTP_HEADER_FILENAME_PATTERN.matcher(fileName);
                if (!fileNameMatcher.matches()) {
                    throw new IOException("incorrect fontFileName");
                }
            }
            catch (UnsupportedEncodingException e) {
                LogUtil.error(e.getMessage(), e);
                fileName = String.valueOf(System.currentTimeMillis());
            }
            response.setHeader("accept-ranges", "bytes");
            response.setHeader(CONTENT_TYPE, "application/octet-stream");
            response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
            AbstractQingAction.loadFile(qingContext, appID, response, DynamicFileTypeEnum.FONT, fileName);
        } else {
            byte[] invalidTip = "No parameter was recognized...".getBytes(UTF_8);
            response.getOutputStream().write(invalidTip);
            response.getOutputStream().flush();
        }
    }

    protected static void loadFile(QingContext qingContext, String appID, HttpServletResponse response, DynamicFileTypeEnum fileType, String fileName) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fileType", fileType.name());
        if (fileType == DynamicFileTypeEnum.FONT) {
            params.put(FILE_NAME, fileName);
        }
        long offset = 0L;
        while (true) {
            byte[] result;
            params.put("offset", String.valueOf(offset));
            try {
                result = ServerFileAccesser.readPartialFile(qingContext, appID, params);
            }
            catch (AbstractQingException e) {
                LogUtil.error(e.getMessage(), e);
                break;
            }
            if (result == null || result.length == 0) break;
            offset += (long)result.length;
            response.getOutputStream().write(result);
            response.getOutputStream().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void protectedUpload(QingContext qingContext, String appID, FileItem fileItem, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String remoteClientIp = HttpUtil.getRemoteClientIp(request);
        if (IpBlackList.getInstance().isInFileBlackList(remoteClientIp)) {
            AbstractQingAction.writeErrorJsonResponse(UploadFileException.noAccessUploadFileException("No access to upload file"), response);
            return;
        }
        InputStream in = null;
        try {
            in = fileItem.getInputStream();
            String fileNameKey = UUID.randomUUID().toString();
            int available = in.available();
            byte[] result = null;
            int index = 0;
            try {
                for (int i = available; i <= available && i > 0; i -= 0x100000) {
                    byte[] buffer = new byte[i > 0x100000 ? 0x100000 : i];
                    if (in.read(buffer) <= 0 || (result = ServerFileAccesser.uploadPiece(qingContext, appID, fileNameKey, buffer, ++index)) == null) continue;
                    available = -1;
                    break;
                }
                if (available > 0) {
                    result = ServerFileAccesser.combineUpload(qingContext, appID, fileNameKey, index);
                }
                AbstractQingAction.writeSuccessJsonResponseZip(result, response);
            }
            catch (AbstractQingException e) {
                AbstractQingAction.writeErrorJsonResponse(e, response);
            }
        }
        catch (Throwable throwable) {
            CloseUtil.close(in);
            fileItem.delete();
            throw throwable;
        }
        CloseUtil.close(in);
        fileItem.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void protectedDownload(QingContext qingContext, String appID, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String appId;
        String fileName = request.getParameter(FILE_NAME);
        String exportUuid = request.getParameter("exportUuid");
        String sIsExport = request.getParameter("isExport");
        try {
            fileName = URLEncoder.encode(fileName, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            LogUtil.error(e.getMessage(), e);
            fileName = System.currentTimeMillis() + "";
        }
        boolean isExport = true;
        if (sIsExport != null && !sIsExport.isEmpty()) {
            isExport = Boolean.parseBoolean(sIsExport);
        }
        if ((appId = request.getParameter(APP_ID)) == null || appId.trim().length() == 0) {
            appId = appID;
        }
        if (!AbstractQingAction.checkExportAccess(qingContext, appId, exportUuid)) {
            throw new IOException("invalid access!");
        }
        Matcher matcher = HTTP_HEADER_FILENAME_PATTERN.matcher(fileName);
        if (matcher.matches()) {
            try {
                String userAgent = request.getHeader(USER_AGENT).toLowerCase();
                if (!userAgent.contains("chrome") && userAgent.contains("safari")) {
                    fileName = URLDecoder.decode(fileName, UTF_8);
                    fileName = new String(fileName.getBytes(), "iso8859-1");
                }
            }
            catch (Exception e) {
                LogUtil.error(e.getMessage(), e);
                fileName = System.currentTimeMillis() + "";
            }
            String contentDis = isExport ? "attachment; filename= " + fileName + ";filename*=utf-8'zh_cn'" + fileName : "inline; filename= " + fileName + ";filename*=utf-8'zh_cn'" + fileName;
            response.setHeader("Content-Disposition", contentDis);
            response.setHeader(CONTENT_TYPE, isExport ? "application/octet-stream" : "application/pdf");
            try {
                ServerFileAccesser.loadFile(qingContext, appId, exportUuid, QingTempFileType.EXPORT, (OutputStream)response.getOutputStream());
            }
            finally {
                try {
                    ServerFileAccesser.delayedDeleteFile(qingContext, appId, exportUuid, QingTempFileType.EXPORT.getTypeIndex(), TimeUnit.MINUTES.toMillis(30L));
                }
                catch (AbstractQingException e) {
                    LogUtil.error("delete file failed!", e);
                }
            }
        }
        throw new IOException("incorrect fileName!");
    }

    private static boolean checkExportAccess(QingContext qingContext, String appId, String exportUuid) {
        String cacheKey = EXPORT_KEY_PREFIX + exportUuid;
        IGlobalQingSession globalQingSession = QingSessionUtil.getGlobalQingSessionImpl();
        String userIdentity = qingContext.getAccountId() + "_" + qingContext.getUserId();
        String cachedUserIdentity = globalQingSession.get(cacheKey);
        if (StringUtils.isNotEmpty(cachedUserIdentity)) {
            return userIdentity.equals(cachedUserIdentity);
        }
        globalQingSession.set(cacheKey, userIdentity, 1, TimeUnit.HOURS);
        return true;
    }

    protected static List<FileItem> getFileItem(HttpServletRequest request) throws IOException, FileUploadException {
        String uploadTempDir = request.getRealPath("/WEB-INF/temp");
        if (uploadTempDir == null) {
            uploadTempDir = System.getProperty("java.io.tmpdir");
        }
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setSizeThreshold(4000000);
        File uploadTempDirFile = new File(uploadTempDir);
        if (uploadTempDirFile.exists() && !uploadTempDirFile.isDirectory()) {
            uploadTempDirFile.delete();
        }
        if (!uploadTempDirFile.exists() || uploadTempDirFile.isDirectory()) {
            uploadTempDirFile.mkdirs();
        }
        factory.setRepository(uploadTempDirFile);
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        return upload.parseRequest(request);
    }

    private static void writeSuccessJsonResponseZip(byte[] result, HttpServletResponse response) throws IOException {
        AbstractQingAction.writeSuccessJsonResponse(result, response, true);
    }

    protected static void writeSuccessJsonResponse(byte[] result, HttpServletResponse response, boolean gzip) throws IOException {
        if (gzip) {
            response.addHeader("Content-Encoding", "gzip");
        }
        response.setHeader(CONTENT_TYPE, "application/json;charset=UTF-8");
        if (result != null) {
            if (gzip) {
                result = ZipUtil.gzip(result);
            }
            response.getOutputStream().write(result);
        }
        response.getOutputStream().flush();
    }

    protected static void writeErrorJsonResponse(Throwable throwable, HttpServletResponse response) throws IOException {
        response.setHeader(CONTENT_TYPE, "application/json;charset=UTF-8");
        response.getOutputStream().write(ResponseUtil.output(throwable));
        response.getOutputStream().flush();
    }

    protected static void protectedLoadFontLibCss(QingContext qingContext, String appID, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setHeader("accept-ranges", "bytes");
        response.setHeader(CONTENT_TYPE, "text/css");
        response.setHeader("Content-Disposition", "attachment; fileName= fontLib.css");
        AbstractQingAction.loadDynamicGenerateFile("CSS", qingContext, response, appID);
    }

    protected static void protectedLoadFontLibJs(QingContext qingContext, String appID, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setHeader("accept-ranges", "bytes");
        response.setHeader(CONTENT_TYPE, "application/javascript");
        response.setHeader("Content-Disposition", "attachment; fileName= fontLib.js");
        AbstractQingAction.loadDynamicGenerateFile("JS", qingContext, response, appID);
    }

    private static void loadDynamicGenerateFile(String fileType, QingContext qingContext, HttpServletResponse response, String appID) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fileType", fileType);
        byte[] result = new byte[]{};
        try {
            result = ServerFileAccesser.readFontFile(qingContext, appID, params);
        }
        catch (AbstractQingException e) {
            LogUtil.error(e.getMessage(), e);
        }
        response.getOutputStream().write(result);
        response.getOutputStream().flush();
    }

    protected static void protectedLoadFontFile(QingContext qingContext, String appID, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String fileName = request.getParameter(FILE_NAME);
        if (fileName != null) {
            fileName = URLEncoder.encode(fileName, UTF_8);
            response.setHeader("accept-ranges", "bytes");
            response.setHeader(CONTENT_TYPE, "application/octet-stream");
            response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
            AbstractQingAction.loadFile(qingContext, appID, response, fileName);
        } else {
            byte[] invalidTip = "No parameter was recognized...".getBytes(UTF_8);
            response.getOutputStream().write(invalidTip);
            response.getOutputStream().flush();
        }
    }

    protected static void loadFile(QingContext qingContext, String appID, HttpServletResponse response, String fileName) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fileType", "FONT");
        params.put(FILE_NAME, fileName);
        long offset = 0L;
        while (true) {
            byte[] result;
            params.put("offset", String.valueOf(offset));
            try {
                result = ServerFileAccesser.readFontFile(qingContext, appID, params);
            }
            catch (AbstractQingException e) {
                LogUtil.error(e.getMessage(), e);
                break;
            }
            if (result == null) break;
            offset += (long)result.length;
            response.getOutputStream().write(result);
            response.getOutputStream().flush();
        }
    }

    protected void doLogException(Throwable e) {
        LogUtil.error(e.getMessage(), e);
    }

    public static interface ISafetyURL {
        public void appendParamToUrl(String var1, String var2);

        public void sendRedirect(HttpServletResponse var1) throws IOException;
    }

    public static class SafetyURL
    implements ISafetyURL {
        public static final String SAFETYCODEKEY = "safetyCode";
        private QingContext qingContext;
        private String appID;
        private String title;
        private String targetURL;
        private String safetyURL;
        private Map<String, String> urlParamMap = new HashMap<String, String>();

        public SafetyURL(QingContext qingContext, String appID, String title, String safetyURL, String targetURL) {
            this.appID = appID;
            this.title = title;
            this.targetURL = targetURL;
            this.safetyURL = safetyURL;
            this.qingContext = qingContext;
        }

        @Override
        public void appendParamToUrl(String sParamKey, String sParamValue) {
            this.urlParamMap.put(sParamKey, sParamValue);
        }

        @Override
        public void sendRedirect(HttpServletResponse response) throws IOException {
            try {
                for (Map.Entry<String, String> urlParamEntry : this.urlParamMap.entrySet()) {
                    String paramKey = urlParamEntry.getKey();
                    String paramValue = urlParamEntry.getValue();
                    this.safetyURL = URLUtil.appendParamToUrl(this.safetyURL, paramKey, paramValue);
                }
                String pageId = URLUtil.getUrlParam(this.safetyURL, AbstractQingAction.PAGE_ID);
                if (StringUtils.isNotBlank(pageId)) {
                    pageId = URLDecoder.decode(pageId, AbstractQingAction.UTF_8);
                }
                String qingMsgNodeId = URLUtil.getUrlParam(this.safetyURL, "qingMsgNodeId");
                String safetyCode = UUID.randomUUID().toString();
                String clientID = UUID.randomUUID().toString();
                ClientManager.initClientAlive(this.qingContext, this.appID, clientID, this.title, safetyCode, this.safetyURL, this.targetURL, pageId, qingMsgNodeId);
                this.safetyURL = URLUtil.appendParamToUrl(this.safetyURL, "safetyCode", safetyCode);
                this.safetyURL = URLUtil.appendParamToUrl(this.safetyURL, AbstractQingAction.CLIENT_ID, clientID);
                response.sendRedirect(this.safetyURL);
            }
            catch (Exception e) {
                LogUtil.error(e.getMessage(), e);
            }
        }
    }
}

