/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.framework.web;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.framework.manage.ClientCallManager;
import com.kingdee.bos.qing.common.framework.manage.ClientManager;
import com.kingdee.bos.qing.common.framework.manage.ServerChannelManager;
import com.kingdee.bos.qing.common.framework.model.AbstractMessage;
import com.kingdee.bos.qing.common.framework.model.QingServiceAsynDispatcherModel;
import com.kingdee.bos.qing.common.framework.model.client.AbstractClientMessage;
import com.kingdee.bos.qing.common.framework.model.client.ClientClosedMessage;
import com.kingdee.bos.qing.common.framework.model.client.ClientPingMessage;
import com.kingdee.bos.qing.common.framework.model.client.ClientPollingMessage;
import com.kingdee.bos.qing.common.framework.model.client.ClientRemoteCallCancelMessage;
import com.kingdee.bos.qing.common.framework.model.client.ClientRemoteCallMessage;
import com.kingdee.bos.qing.common.framework.model.client.ServerChannelAckMessage;
import com.kingdee.bos.qing.common.framework.model.client.ServerRemoteCallAckMessage;
import com.kingdee.bos.qing.common.framework.model.server.AbstractServerMessage;
import com.kingdee.bos.qing.common.framework.model.server.ServerChannelMessage;
import com.kingdee.bos.qing.common.framework.model.server.ServerRemoteCallMessage;
import com.kingdee.bos.qing.common.framework.server.msgpublish.ServerChannelMessagePublisher;
import com.kingdee.bos.qing.common.framework.server.task.InvokeHealthCheckTask;
import com.kingdee.bos.qing.common.framework.server.task.ServerRequestInvokeContext;
import com.kingdee.bos.qing.common.framework.web.IServerMessageSender;
import com.kingdee.bos.qing.common.framework.web.dependency.QingWebRequestDispatcher;
import com.kingdee.bos.qing.response.AbstractResponseWrap;
import com.kingdee.bos.qing.response.ResponseErrorWrap;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.ThreadPoolManage;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ClientMessageHandler {
    private static Map<String, IClientMessageHandler> CLIENTMESSAGEHANDLERS = new HashMap<String, IClientMessageHandler>();

    public static void handle(QingContext qingContext, IServerMessageSender messageListener, List<AbstractClientMessage> clientMessages) {
        ArrayList<AbstractServerMessage> acks = new ArrayList<AbstractServerMessage>();
        ArrayList<MessageHandlerTask> messageHandlerTasks = new ArrayList<MessageHandlerTask>();
        ArrayList<MessageHandlerTask> concurrentMessageHandlerTasks = new ArrayList<MessageHandlerTask>();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        ClientPingMessage clientPingMessage = null;
        HashSet<String> clientIDs = new HashSet<String>();
        Iterator<AbstractClientMessage> clientMessagesIterator = clientMessages.iterator();
        while (clientMessagesIterator.hasNext()) {
            Iterator clientMessage = clientMessagesIterator.next();
            ((AbstractClientMessage)((Object)clientMessage)).collectAliveClientIDs(clientIDs);
            acks.addAll(((AbstractClientMessage)((Object)clientMessage)).createAcks());
            if (((AbstractMessage)((Object)clientMessage)).isClientPingMessage()) {
                ClientPingMessage tempClientPingMessage = (ClientPingMessage)((Object)clientMessage);
                if (clientPingMessage == null) {
                    clientPingMessage = tempClientPingMessage;
                } else {
                    List<String> oldClientIDs = clientPingMessage.getClientIDs();
                    HashSet<String> newClientIDS = new HashSet<String>();
                    newClientIDS.addAll(oldClientIDs);
                    newClientIDS.addAll(tempClientPingMessage.getClientIDs());
                    clientPingMessage.setClientIDs(new ArrayList<String>(newClientIDS));
                }
                clientIDs.addAll(tempClientPingMessage.getClientIDs());
                clientMessagesIterator.remove();
                continue;
            }
            IClientMessageHandler clientMessageHandler = CLIENTMESSAGEHANDLERS.get(clientMessage.getClass().getName());
            MessageHandlerTask messageHandlerTask = new MessageHandlerTask(qingContext, messageListener, clientMessageHandler, (AbstractClientMessage)((Object)clientMessage));
            if (((AbstractMessage)((Object)clientMessage)).isClientReomteCallMessage()) {
                if (concurrentMessageHandlerTasks.isEmpty()) {
                    messageHandlerTask.setCountDownLatch(countDownLatch);
                }
                concurrentMessageHandlerTasks.add(messageHandlerTask);
                continue;
            }
            messageHandlerTasks.add(messageHandlerTask);
        }
        ClientManager.setClientAlive(qingContext, clientIDs);
        for (AbstractServerMessage ack : acks) {
            messageListener.sendMessage(ack);
        }
        ClientMessageHandler.sendServerChannelMessage(messageListener, clientIDs);
        if (!clientMessages.isEmpty()) {
            for (MessageHandlerTask messageHandlerTask : concurrentMessageHandlerTasks) {
                messageHandlerTask.runInServer();
                ThreadPoolManage.excuteThreadWithContext(ThreadPoolManage.QingThreadPoolName.QING_SHORT_TIME_TASK_HANDLER, messageHandlerTask, qingContext);
            }
            for (MessageHandlerTask messageHandlerTask : messageHandlerTasks) {
                messageHandlerTask.call();
            }
            if (!concurrentMessageHandlerTasks.isEmpty()) {
                try {
                    boolean returValue = countDownLatch.await(3L, TimeUnit.SECONDS);
                    if (returValue && LogUtil.isDebugEnabled()) {
                        LogUtil.debug("countDownLatch waite for RPC remote true in 3S");
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private static void sendServerChannelMessage(IServerMessageSender messageListener, Collection<String> clientIDs) {
        if (clientIDs != null && !clientIDs.isEmpty()) {
            for (String clientID : clientIDs) {
                ClientMessageHandler.sendServerChannelMessage(messageListener, clientID);
            }
        }
    }

    private static void sendServerChannelMessage(IServerMessageSender messageListener, String clientID) {
        List<ServerChannelMessage> channelMessages = ServerChannelMessagePublisher.getServerChannelMessages(clientID);
        if (!channelMessages.isEmpty()) {
            for (ServerChannelMessage serverChannelMessage : channelMessages) {
                messageListener.sendMessage(serverChannelMessage);
            }
        }
    }

    static {
        CLIENTMESSAGEHANDLERS.put(ClientRemoteCallMessage.class.getName(), new ClientRemoteCallMessageHandler());
        CLIENTMESSAGEHANDLERS.put(ClientRemoteCallCancelMessage.class.getName(), new ClientRemoteCallCancelMessageHandler());
        CLIENTMESSAGEHANDLERS.put(ClientClosedMessage.class.getName(), new ClientClosedMessageHandler());
        CLIENTMESSAGEHANDLERS.put(ServerRemoteCallAckMessage.class.getName(), new ServerRemoteCallAckMessageHandler());
        CLIENTMESSAGEHANDLERS.put(ServerChannelAckMessage.class.getName(), new ServerChannelAckMessageHandler());
        CLIENTMESSAGEHANDLERS.put(ClientPollingMessage.class.getName(), new ClientPollingMessageHandler());
    }

    private static class ClientPollingMessageHandler
    extends AbstractClientMessageHandler<ClientPollingMessage> {
        private ClientPollingMessageHandler() {
        }

        @Override
        public void handle(QingContext qingContext, ServerRequestInvokeContext serverRequestInvokeContext, IServerMessageSender messageListener, ClientPollingMessage clientMessage) {
            List<String> clientIDAndCallIDs = clientMessage.getClientIDAndCallIDs();
            for (String clientIDAndCallID : clientIDAndCallIDs) {
                String callID;
                String[] clientIDAndCallIDValue = clientIDAndCallID.split("\\|");
                String clientID = clientIDAndCallIDValue[0];
                ServerRemoteCallMessage serverMessageWraper = ClientCallManager.getCallResult(clientID, callID = clientIDAndCallIDValue[1]);
                if (serverMessageWraper == null) continue;
                messageListener.sendMessage(serverMessageWraper);
                LogUtil.info("web node call " + callID + " end");
            }
        }
    }

    private static class ServerChannelAckMessageHandler
    extends AbstractClientMessageHandler<ServerChannelAckMessage> {
        private ServerChannelAckMessageHandler() {
        }

        @Override
        public void handle(QingContext qingContext, ServerRequestInvokeContext serverRequestInvokeContext, IServerMessageSender messageListener, ServerChannelAckMessage clientMessage) {
            String callID = clientMessage.getCallID();
            String clientID = clientMessage.getClientID();
            ClientCallManager.setCallFinish(clientID, callID);
            ServerChannelManager.removeCallID(clientID, new String[]{callID});
        }
    }

    private static class ServerRemoteCallAckMessageHandler
    extends AbstractClientMessageHandler<ServerRemoteCallAckMessage> {
        private ServerRemoteCallAckMessageHandler() {
        }

        @Override
        public void handle(QingContext qingContext, ServerRequestInvokeContext serverRequestInvokeContext, IServerMessageSender messageListener, ServerRemoteCallAckMessage clientMessage) {
            String callID = clientMessage.getCallID();
            String clientID = clientMessage.getClientID();
            ServerRemoteCallMessage serverMessageWraper = ClientCallManager.getCallResult(clientID, callID);
            if (serverMessageWraper != null) {
                AbstractResponseWrap responseWrap = serverMessageWraper.getData();
                responseWrap.deleteCacheFile(qingContext);
            }
            ClientCallManager.setCallFinish(clientID, callID);
        }
    }

    private static class ClientClosedMessageHandler
    extends AbstractClientMessageHandler<ClientClosedMessage> {
        private ClientClosedMessageHandler() {
        }

        @Override
        public void handle(QingContext qingContext, ServerRequestInvokeContext serverRequestInvokeContext, IServerMessageSender messageListener, ClientClosedMessage clientMessage) {
            List<String> clientIDs = clientMessage.getClientIDs();
            ClientManager.setClientClosed(qingContext, clientIDs);
        }
    }

    private static class ClientRemoteCallCancelMessageHandler
    extends AbstractClientMessageHandler<ClientRemoteCallCancelMessage> {
        private ClientRemoteCallCancelMessageHandler() {
        }

        @Override
        public void handle(QingContext qingContext, ServerRequestInvokeContext serverRequestInvokeContext, IServerMessageSender messageListener, ClientRemoteCallCancelMessage clientMessage) {
            String clientID = clientMessage.getClientID();
            String callID = clientMessage.getCallID();
            ClientCallManager.setCallCanceled(clientID, callID);
        }
    }

    private static class ClientRemoteCallMessageHandler
    implements IClientMessageHandler<ClientRemoteCallMessage> {
        private ClientRemoteCallMessageHandler() {
        }

        @Override
        public ServerRequestInvokeContext runInServer(ClientRemoteCallMessage clientMessage) {
            String callID;
            String appID = clientMessage.getAppID();
            String clientID = clientMessage.getClientID();
            if (!ClientCallManager.isCallWorkingInServer(ServerRequestInvokeContext.CheckerName.Web, clientID, callID = clientMessage.getCallID(), false)) {
                ServerRequestInvokeContext invokeContext = new ServerRequestInvokeContext(ServerRequestInvokeContext.CheckerName.Web, appID, clientMessage.getClientID(), clientMessage.getCallID(), clientMessage.getOrderID());
                InvokeHealthCheckTask.addInvokeContext(invokeContext);
                return invokeContext;
            }
            return null;
        }

        private static String dispatch(QingContext qingContext, ClientRemoteCallMessage clientMessage) throws AbstractQingException, UnsupportedEncodingException {
            QingServiceAsynDispatcherModel model = new QingServiceAsynDispatcherModel();
            model.setServiceType(clientMessage.getServiceType());
            model.setClientID(clientMessage.getClientID());
            model.setCallID(clientMessage.getCallID());
            model.setOrderID(clientMessage.getOrderID());
            model.setAppID(clientMessage.getAppID());
            model.setMethodName(clientMessage.getRemoteMethod());
            model.setParameters(new Object[]{clientMessage.getParams()});
            byte[] result = (byte[])QingWebRequestDispatcher.asynDispatcher(qingContext, clientMessage.getAppID(), model);
            if (result == null) {
                return null;
            }
            return new String(result, "utf-8");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(QingContext qingContext, ServerRequestInvokeContext serverRequestInvokeContext, IServerMessageSender messageListener, ClientRemoteCallMessage clientMessage) {
            block5: {
                try {
                    if (serverRequestInvokeContext == null) break block5;
                    LogUtil.info("web node call " + serverRequestInvokeContext.getCallID() + " start");
                    ServerRequestInvokeContext.setThreadLocal(serverRequestInvokeContext);
                    String jsonResult = this.doHandle(qingContext, messageListener, clientMessage);
                    if (jsonResult == null) break block5;
                    ServerRemoteCallMessage serverRemoteCallMessage = null;
                    try {
                        serverRemoteCallMessage = (ServerRemoteCallMessage)AbstractServerMessage.decodeFromJsonString(jsonResult);
                    }
                    catch (Exception e) {
                        ResponseErrorWrap result = new ResponseErrorWrap(e);
                        serverRemoteCallMessage = new ServerRemoteCallMessage(clientMessage.getClientID(), clientMessage.getCallID(), clientMessage.getOrderID(), result);
                    }
                    messageListener.sendMessage(serverRemoteCallMessage);
                    serverRequestInvokeContext.stopHealthCheck();
                    LogUtil.info("web node call " + serverRequestInvokeContext.getCallID() + " end");
                }
                finally {
                    ServerRequestInvokeContext.removeThreadLocal();
                }
            }
        }

        private String doHandle(QingContext qingContext, IServerMessageSender messageListener, ClientRemoteCallMessage clientMessage) {
            try {
                return ClientRemoteCallMessageHandler.dispatch(qingContext, clientMessage);
            }
            catch (Exception e) {
                ResponseErrorWrap result = new ResponseErrorWrap(e);
                ServerRemoteCallMessage responseRemoteCallMessage = new ServerRemoteCallMessage(clientMessage.getClientID(), clientMessage.getCallID(), clientMessage.getOrderID(), result);
                return responseRemoteCallMessage.toJson();
            }
        }
    }

    private static class MessageHandlerTask
    implements Callable<Object> {
        private QingContext qingContext;
        private IServerMessageSender messageListener;
        private AbstractClientMessage clientMessage;
        private IClientMessageHandler<AbstractClientMessage> clientMessageHandler;
        private ServerRequestInvokeContext invokeContext;
        private CountDownLatch countDownLatch;

        private MessageHandlerTask(QingContext qingContext, IServerMessageSender messageListener, IClientMessageHandler<AbstractClientMessage> clientMessageHandler, AbstractClientMessage clientMessage) {
            this.qingContext = qingContext;
            this.messageListener = messageListener;
            this.clientMessageHandler = clientMessageHandler;
            this.clientMessage = clientMessage;
        }

        public void setCountDownLatch(CountDownLatch countDownLatch) {
            this.countDownLatch = countDownLatch;
        }

        public void runInServer() {
            this.invokeContext = this.clientMessageHandler.runInServer(this.clientMessage);
        }

        @Override
        public Object call() {
            try {
                this.clientMessageHandler.handle(this.qingContext, this.invokeContext, this.messageListener, this.clientMessage);
            }
            finally {
                if (this.countDownLatch != null) {
                    this.countDownLatch.countDown();
                }
            }
            return null;
        }
    }

    private static abstract class AbstractClientMessageHandler<T>
    implements IClientMessageHandler<T> {
        private AbstractClientMessageHandler() {
        }

        @Override
        public ServerRequestInvokeContext runInServer(T clientMessage) {
            return null;
        }
    }

    private static interface IClientMessageHandler<T> {
        public void handle(QingContext var1, ServerRequestInvokeContext var2, IServerMessageSender var3, T var4);

        public ServerRequestInvokeContext runInServer(T var1);
    }
}

