/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.lock;

import com.kingdee.bos.qing.common.lock.ILockFuture;
import com.kingdee.bos.qing.common.lock.QingLockRequireException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class LockFuture
implements ILockFuture {
    private CountDownLatch latch;
    private boolean lockResult = false;
    private Exception exception;

    public void setLatch(CountDownLatch latch) {
        this.latch = latch;
    }

    public void setLockResult(boolean lockResult) {
        this.lockResult = lockResult;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    @Override
    public boolean getLockResult(long timeOut, TimeUnit unit) throws InterruptedException, QingLockRequireException {
        if (null != this.exception) {
            throw new QingLockRequireException("", this.exception);
        }
        if (null == this.latch) {
            return this.lockResult;
        }
        if (-1L == timeOut) {
            this.latch.await();
            return true;
        }
        return this.latch.await(timeOut, unit);
    }

    @Override
    public boolean getLockResultImmediate() {
        if (this.latch != null) {
            return this.latch.getCount() == 0L;
        }
        return this.lockResult;
    }
}

