/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.rpc.client;

import com.kingdee.bos.qing.common.rpc.client.QRpcClient;
import com.kingdee.bos.qing.common.rpc.client.QRpcClientFactory;
import com.kingdee.bos.qing.common.rpc.common.QRpcSystemApp;
import com.kingdee.bos.qing.common.rpc.exception.QRpcConnectException;
import com.kingdee.bos.qing.util.SystemPropertyUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QRpcClientPool {
    private static final Logger log = LoggerFactory.getLogger((String)QRpcClientPool.class.getName());
    private static final QRpcClientPool instance = new QRpcClientPool();
    private Map<String, GenericObjectPool<QRpcClient>> clientPools = new HashMap<String, GenericObjectPool<QRpcClient>>();

    private QRpcClientPool() {
    }

    public static QRpcClientPool getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnClient(QRpcClient qRpcClient) {
        if (null == qRpcClient) {
            return;
        }
        String key = this.getClientKey(qRpcClient.getSystemApp(), qRpcClient.getRemoteAddress(), qRpcClient.getRemotePort());
        GenericObjectPool<QRpcClient> clientPool = null;
        QRpcClientPool qRpcClientPool = this;
        synchronized (qRpcClientPool) {
            clientPool = this.clientPools.get(key);
        }
        if (null != clientPool) {
            clientPool.returnObject((Object)qRpcClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QRpcClient borrowClient(QRpcSystemApp systemApp, String remoteServer, int port) throws QRpcConnectException {
        GenericObjectPool clientPool = null;
        QRpcClientPool qRpcClientPool = this;
        synchronized (qRpcClientPool) {
            String clientKey = this.getClientKey(systemApp, remoteServer, port);
            clientPool = this.clientPools.get(clientKey);
            if (null == clientPool) {
                QRpcClientFactory factory = new QRpcClientFactory(systemApp, remoteServer, port);
                GenericObjectPoolConfig config = new GenericObjectPoolConfig();
                config.setMaxIdle(SystemPropertyUtil.getInt("qing.rpc.client.maxidle", 8));
                config.setMinIdle(SystemPropertyUtil.getInt("qing.rpc.client.minidle", 4));
                config.setMaxTotal(SystemPropertyUtil.getInt("qing.rpc.client.maxsize", 20));
                config.setBlockWhenExhausted(true);
                config.setTestOnBorrow(true);
                config.setTestOnReturn(true);
                config.setMinEvictableIdleTimeMillis(600000L);
                config.setMaxWaitMillis((long)SystemPropertyUtil.getInt("qing.rpc.client.maxwaitmillis", 30000));
                clientPool = new GenericObjectPool((PooledObjectFactory)factory, config);
                this.clientPools.put(clientKey, (GenericObjectPool<QRpcClient>)clientPool);
            }
        }
        try {
            return (QRpcClient)clientPool.borrowObject();
        }
        catch (Exception e) {
            throw new QRpcConnectException("could not connect to server,server:" + remoteServer + ",port:" + port, e);
        }
    }

    protected String getClientKey(QRpcSystemApp systemApp, String remoteServer, int port) {
        return systemApp.name() + ":" + remoteServer + ":" + port;
    }
}

