/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.rpc.codec;

import com.kingdee.bos.qing.common.rpc.codec.VersionCodec;
import com.kingdee.bos.qing.common.rpc.codec.compression.Compression;
import com.kingdee.bos.qing.common.rpc.codec.compression.CompressionFactory;
import com.kingdee.bos.qing.common.rpc.codec.serialization.QRpcSerialization;
import com.kingdee.bos.qing.common.rpc.codec.serialization.SerializationFactory;
import com.kingdee.bos.qing.common.rpc.codec.serialization.inbound.ObjectInput;
import com.kingdee.bos.qing.common.rpc.codec.serialization.outbound.ObjectOutput;
import com.kingdee.bos.qing.common.rpc.common.QRpcConfiguration;
import com.kingdee.bos.qing.common.rpc.exception.QRpcCodecException;
import com.kingdee.bos.qing.common.rpc.model.QRpcHeartBeat;
import com.kingdee.bos.qing.common.rpc.model.QRpcInvocation;
import com.kingdee.bos.qing.common.rpc.model.QRpcInvokeResult;
import com.kingdee.bos.qing.common.rpc.model.QRpcMessage;
import com.kingdee.bos.qing.common.rpc.model.QRpcResultStatus;
import com.kingdee.bos.qing.util.StackTraceUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class QRpcVersionMsgCodec
implements VersionCodec<QRpcMessage> {
    private static final int MAX_MSG_SIZE = QRpcConfiguration.getMsgMaxSize();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object decode(ByteBuf frame) {
        byte msgType = frame.readByte();
        byte serializationType = frame.readByte();
        byte compressType = frame.readByte();
        long seq = frame.readLong();
        int dataLength = frame.readInt();
        ByteBuf datas = Unpooled.buffer((int)dataLength);
        QRpcSerialization rpcSerialization = SerializationFactory.createSerialization(serializationType);
        if (null == rpcSerialization) {
            return this.createErrorDecodeMsg(seq, serializationType, compressType, new QRpcCodecException("illegal serialization type:" + serializationType));
        }
        Compression compression = CompressionFactory.getCompression(compressType);
        if (null == compression) {
            return this.createErrorDecodeMsg(seq, serializationType, compressType, new QRpcCodecException("illegal compress type:" + compressType));
        }
        ObjectInput objectInput = null;
        try {
            frame.readBytes(datas, dataLength);
            ByteBufInputStream inputStream = new ByteBufInputStream(datas);
            InputStream unCompressInputStream = compression.createInput((InputStream)inputStream);
            objectInput = rpcSerialization.getDeserializeInput(unCompressInputStream);
            Object data = null;
            switch (msgType) {
                case 1: {
                    data = objectInput.readObject(QRpcInvocation.class);
                    break;
                }
                case 0: {
                    data = objectInput.readObject(QRpcInvokeResult.class);
                    break;
                }
                case 2: {
                    data = objectInput.readObject(QRpcHeartBeat.class);
                }
            }
            QRpcMessage qRpcMessage = new QRpcMessage(seq, compressType, serializationType, 11, data);
            return qRpcMessage;
        }
        catch (QRpcCodecException e) {
            QRpcMessage qRpcMessage = this.createErrorDecodeMsg(seq, serializationType, compressType, e);
            return qRpcMessage;
        }
        catch (Exception e) {
            QRpcMessage qRpcMessage = this.createErrorDecodeMsg(seq, serializationType, compressType, new QRpcCodecException(e));
            return qRpcMessage;
        }
        finally {
            datas.release();
            if (null != objectInput) {
                objectInput.close();
            }
        }
    }

    private QRpcMessage createErrorDecodeMsg(long seq, byte serializationType, byte compressType, QRpcCodecException e) {
        QRpcInvokeResult resp = new QRpcInvokeResult();
        resp.setStatus(QRpcResultStatus.MODEL_VERSION_INCONSISTENT);
        resp.setErrInfo(e.getCause() != null ? StackTraceUtil.getStackTrace(e.getCause()) : e.getMessage());
        return new QRpcMessage(seq, compressType, serializationType, 11, resp);
    }

    @Override
    public void encode(ByteBuf byteBuf, QRpcMessage message) throws QRpcCodecException {
        ByteBuf headByteBuf = Unpooled.buffer((int)20);
        ByteBuf bodyBuff = Unpooled.buffer((int)1024, (int)MAX_MSG_SIZE);
        ObjectOutput objOutput = null;
        try {
            headByteBuf.writeShort(-9222);
            headByteBuf.writeByte((int)message.getVersion());
            headByteBuf.writeByte((int)message.getMsgType());
            headByteBuf.writeByte((int)message.getSerializeType());
            headByteBuf.writeByte((int)message.getCompressType());
            headByteBuf.writeLong(message.getSeq());
            ByteBufOutputStream outputStream = new ByteBufOutputStream(bodyBuff);
            Compression compression = CompressionFactory.getCompression(message.getCompressType());
            if (null == compression) {
                throw new QRpcCodecException("illegal compresss type:" + message.getCompressType());
            }
            OutputStream outputWithCompress = compression.createOutput((OutputStream)outputStream);
            QRpcSerialization rpcSerialization = SerializationFactory.createSerialization(message.getSerializeType());
            if (null == rpcSerialization) {
                throw new QRpcCodecException("illegal serialise type:" + message.getSerializeType());
            }
            try {
                objOutput = rpcSerialization.getSerializeOutput(outputWithCompress);
                objOutput.writeObject(message.getData());
                objOutput.flush();
            }
            catch (Exception e) {
                throw new QRpcCodecException("encode rpc msg error", e);
            }
            finally {
                if (null != objOutput) {
                    objOutput.close();
                }
            }
            headByteBuf.writeInt(bodyBuff.readableBytes());
            byteBuf.writeBytes(headByteBuf);
            byteBuf.writeBytes(bodyBuff);
        }
        catch (IOException e) {
            throw new QRpcCodecException("rpc codec error", e);
        }
        finally {
            headByteBuf.release();
            bodyBuff.release();
        }
    }

    @Override
    public Class getMsgClassType() {
        return QRpcMessage.class;
    }
}

