/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.rpc.codec.compression;

import com.kingdee.bos.qing.common.rpc.codec.compression.Compression;
import com.kingdee.bos.qing.common.rpc.codec.compression.CompressionFactory;
import com.kingdee.bos.qing.common.rpc.exception.QRpcCodecException;
import com.kingdee.bos.qing.common.rpc.exception.QRpcException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CompressSupport {
    public static OutputStream wrapOutputWithCompress(OutputStream out, byte compressType) throws QRpcException {
        Compression compression = CompressionFactory.getCompression(compressType);
        if (null == compression) {
            throw new QRpcCodecException("illegal compress type:" + compressType);
        }
        try {
            return compression.createOutput(out);
        }
        catch (IOException e) {
            throw new QRpcCodecException("create compression output error", e);
        }
    }

    public static InputStream wrapInputWithUnCompress(InputStream in, byte compressType) throws QRpcException {
        try {
            Compression compression = CompressionFactory.getCompression(compressType);
            if (null == compression) {
                throw new QRpcCodecException("illegal compress type:" + compressType);
            }
            return compression.createInput(in);
        }
        catch (IOException e) {
            throw new QRpcCodecException("illegal compress type:" + compressType, e);
        }
    }
}

