/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.rpc.common;

import com.kingdee.bos.qing.common.rpc.common.QRpcRemoteCaller;
import com.kingdee.bos.qing.common.rpc.exception.QRpcInvokeErrorWithStatus;
import java.lang.reflect.UndeclaredThrowableException;

public class QRpcInvokeHelper {
    public static <T> T callRemote(QRpcRemoteCaller<T> caller) throws Throwable {
        try {
            return caller.call();
        }
        catch (UndeclaredThrowableException e) {
            throw e.getCause();
        }
    }

    public static <T> T retryableCall(QRpcRemoteCaller<T> caller, int maxRetryTimes) throws Exception {
        return QRpcInvokeHelper.retryableCall(caller, maxRetryTimes, 1000L);
    }

    private static void delaySomeTime(long delayTime) {
        try {
            Thread.sleep(delayTime);
        }
        catch (InterruptedException e) {
            return;
        }
    }

    public static <T> T retryableCall(QRpcRemoteCaller<T> caller, int maxRetryTimes, long delayTime) throws Exception {
        Exception error = null;
        int calledCounts = 0;
        while (maxRetryTimes > 0) {
            if (delayTime > 0L && calledCounts > 0) {
                QRpcInvokeHelper.delaySomeTime(delayTime);
            }
            try {
                return caller.call();
            }
            catch (QRpcInvokeErrorWithStatus errorWithStatus) {
                switch (errorWithStatus.getStatus()) {
                    case TIMEOUT: 
                    case CONNECT_ERROR: {
                        --maxRetryTimes;
                        error = errorWithStatus;
                        break;
                    }
                    default: {
                        maxRetryTimes = 0;
                        error = errorWithStatus;
                        break;
                    }
                }
            }
            catch (UndeclaredThrowableException e) {
                Throwable cause = e.getCause();
                if (cause instanceof QRpcInvokeErrorWithStatus) {
                    QRpcInvokeErrorWithStatus err = (QRpcInvokeErrorWithStatus)cause;
                    switch (err.getStatus()) {
                        case TIMEOUT: 
                        case CONNECT_ERROR: {
                            --maxRetryTimes;
                            error = err;
                            break;
                        }
                        default: {
                            maxRetryTimes = 0;
                            error = err;
                            break;
                        }
                    }
                } else {
                    maxRetryTimes = 0;
                    error = e;
                }
            }
            catch (Exception e) {
                maxRetryTimes = 0;
                error = e;
            }
            ++calledCounts;
        }
        if (null != error) {
            throw error;
        }
        return null;
    }
}

