/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.rpc.common;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.rpc.api.IQRpcInvokerClosable;
import com.kingdee.bos.qing.common.rpc.common.QRpcSystem;
import com.kingdee.bos.qing.common.rpc.model.QRpcInvocation;
import com.kingdee.bos.qing.common.rpc.model.QRpcInvokeResult;
import com.kingdee.bos.qing.common.rpc.model.QRpcInvokerInfo;
import com.kingdee.bos.qing.common.rpc.model.QRpcMessage;
import com.kingdee.bos.qing.common.rpc.model.QRpcResultStatus;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.MethodInvokeUtil;
import com.kingdee.bos.qing.util.StackTraceUtil;
import com.kingdee.bos.qing.util.ThreadPoolManage;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.GenericFutureListener;

public class QRpcInvoker {
    private QRpcInvokerInfo invokerInfo;
    private volatile boolean closed = false;
    private long lastActiveTime = System.currentTimeMillis();

    public QRpcInvoker(QRpcInvokerInfo invokerInfo) {
        this.invokerInfo = invokerInfo;
    }

    public void invoke(final ChannelHandlerContext ctx, final QRpcMessage reqRpcMsg, final QRpcInvocation rpcInvocation) {
        ThreadPoolManage.submit(ThreadPoolManage.QingThreadPoolName.QING_RPC_INVOKER_TASK_HANDLER, new Runnable(){

            @Override
            public void run() {
                try {
                    final long seq = reqRpcMsg.getSeq();
                    long beginTime = System.currentTimeMillis();
                    QRpcInvokeResult invokeResult = QRpcInvoker.this.doInvoke(rpcInvocation);
                    long endTime = System.currentTimeMillis();
                    LogUtil.info("QingRPC: invoke method time:" + (endTime - beginTime) + ", seq=" + seq + ". " + rpcInvocation);
                    invokeResult.setSeq(seq);
                    QRpcMessage dppMessage = new QRpcMessage(seq, reqRpcMsg.getCompressType(), reqRpcMsg.getSerializeType(), reqRpcMsg.getVersion(), invokeResult);
                    final long beginSendBackTime = System.currentTimeMillis();
                    ChannelPromise promise = ctx.channel().newPromise();
                    promise.addListener((GenericFutureListener)new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture channelFuture) throws Exception {
                            long sendFinishTime = System.currentTimeMillis();
                            long duration = sendFinishTime - beginSendBackTime;
                            if (!channelFuture.isSuccess()) {
                                Throwable throwable = channelFuture.cause();
                                LogUtil.error("QingRPC: invoke method failed, invocation:" + rpcInvocation + ", seq=" + seq + ",duration = " + duration, throwable);
                            } else {
                                LogUtil.info("QingRPC: send invoke result succeed\uff0c seq=" + seq + ", invocation:" + rpcInvocation + ",duration = " + duration);
                            }
                        }
                    });
                    ctx.writeAndFlush((Object)dppMessage, promise);
                }
                catch (Exception e) {
                    LogUtil.error("QingRPC: invoke method failed, invocation:" + rpcInvocation, e);
                }
            }
        });
    }

    public boolean isTemporary() {
        return this.invokerInfo.isTemporary();
    }

    protected QRpcInvokeResult doInvoke(QRpcInvocation invocation) {
        if (this.invokerInfo.isTemporary()) {
            this.lastActiveTime = System.currentTimeMillis();
        }
        Object serviceInstance = this.invokerInfo.getServiceInstance();
        QRpcInvokeResult invokeResult = new QRpcInvokeResult();
        invokeResult.setReceiverId(invocation.getDeliverId());
        if (null == serviceInstance) {
            invokeResult.setStatus(QRpcResultStatus.SERVICE_NOT_FOUND);
            invokeResult.setErrInfo("remote invoker not found,invoker id:" + this.invokerInfo.getId());
            return invokeResult;
        }
        String methodName = invocation.getMethod();
        Object[] arguments = invocation.getArguments();
        try {
            QingContext qingContext = QRpcSystem.getSystem(invocation.getAppName()).getContextCodec().decodeContext(invocation.getRequestContext());
            QingContext.setCurrent(qingContext);
            Object result = MethodInvokeUtil.invoke(serviceInstance, methodName, arguments);
            invokeResult.setStatus(QRpcResultStatus.SUCCEED);
            invokeResult.setData(result);
            return invokeResult;
        }
        catch (Throwable e) {
            LogUtil.error("invoke service method failed", e);
            invokeResult.setStatus(QRpcResultStatus.SERVICE_INVOKE_ERROR);
            String errInfo = StackTraceUtil.getStackTrace(this.getCause(e));
            invokeResult.setErrInfo(errInfo);
            return invokeResult;
        }
    }

    public long getLastActiveTime() {
        return this.lastActiveTime;
    }

    private Throwable getCause(Throwable e) {
        if (e.getCause() != null) {
            return e.getCause();
        }
        return e;
    }

    public String getId() {
        return this.invokerInfo.getId();
    }

    public long getDestroyTime() {
        if (this.invokerInfo.isTemporary()) {
            return this.invokerInfo.getDestroyTime();
        }
        return Long.MAX_VALUE;
    }

    public void close() {
        this.closed = true;
        Object serviceInstance = this.invokerInfo.getServiceInstance();
        if (serviceInstance instanceof IQRpcInvokerClosable) {
            IQRpcInvokerClosable invoker = (IQRpcInvokerClosable)serviceInstance;
            invoker.close();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }
}

