/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.rpc.common;

import com.kingdee.bos.qing.common.rpc.codec.IQRpcContextCodec;
import com.kingdee.bos.qing.common.rpc.codec.NonRpcContextCodec;
import com.kingdee.bos.qing.common.rpc.common.DummyInvoker;
import com.kingdee.bos.qing.common.rpc.common.DummyQRpcSystem;
import com.kingdee.bos.qing.common.rpc.common.QRpcInvoker;
import com.kingdee.bos.qing.common.rpc.common.QRpcSystemApp;
import com.kingdee.bos.qing.common.rpc.model.QRpcInvokerInfo;
import com.kingdee.bos.qing.common.rpc.server.QRpcServer;
import com.kingdee.bos.qing.common.thread.GlobalScheduledExecutor;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public abstract class QRpcSystem {
    private static final Map<QRpcSystemApp, QRpcSystem> RPC_SYSTEMS = new ConcurrentHashMap<QRpcSystemApp, QRpcSystem>(3);
    protected IQRpcContextCodec contextCodec;
    private QRpcServer rpcServer;
    private Map<String, QRpcInvoker> instanceMap = new HashMap<String, QRpcInvoker>(10);

    protected void setRpcServer(QRpcServer qRpcServer) {
        this.rpcServer = qRpcServer;
    }

    public abstract void startUp() throws Throwable;

    public IQRpcContextCodec getContextCodec() {
        if (null == this.contextCodec) {
            return new NonRpcContextCodec();
        }
        return this.contextCodec;
    }

    public static void setCurrent(QRpcSystem qRpcSystem) {
        RPC_SYSTEMS.put(qRpcSystem.getSystemApp(), qRpcSystem);
    }

    public static QRpcSystem getSystem(QRpcSystemApp app) {
        QRpcSystem system = RPC_SYSTEMS.get((Object)app);
        if (null == system) {
            return new DummyQRpcSystem();
        }
        return system;
    }

    public String getServerIp() {
        return this.rpcServer.getServerIp();
    }

    public int getServerBindPort() {
        return this.rpcServer.getServerPort();
    }

    public abstract QRpcSystemApp getSystemApp();

    public boolean isStarted() {
        return null != this.rpcServer && this.rpcServer.isStarted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInvoker(QRpcInvokerInfo invokerInfo) {
        Map<String, QRpcInvoker> map = this.instanceMap;
        synchronized (map) {
            String id = invokerInfo.getId();
            if (this.instanceMap.containsKey(id) && !invokerInfo.isOverrideExist()) {
                return;
            }
            this.instanceMap.put(id, new QRpcInvoker(invokerInfo));
        }
    }

    protected void startTempInvokerCleanTask() {
        GlobalScheduledExecutor.scheduleAtFixRate(new TemporaryInvokerChecker(), 100L, 10000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInvoker(String id) {
        Map<String, QRpcInvoker> map = this.instanceMap;
        synchronized (map) {
            LogUtil.info("QingRPC: remove invoker,id:" + id);
            QRpcInvoker qRpcInvoker = this.instanceMap.remove(id);
            if (null != qRpcInvoker) {
                qRpcInvoker.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QRpcInvoker getInvoker(String instanceId) {
        Map<String, QRpcInvoker> map = this.instanceMap;
        synchronized (map) {
            QRpcInvoker invoker = this.instanceMap.get(instanceId);
            if (null == invoker) {
                return new DummyInvoker();
            }
            return invoker;
        }
    }

    private class TemporaryInvokerChecker
    implements Runnable {
        private TemporaryInvokerChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashSet temporaryInvokers = new HashSet(10);
            Map map = QRpcSystem.this.instanceMap;
            synchronized (map) {
                temporaryInvokers.addAll(QRpcSystem.this.instanceMap.values());
            }
            for (QRpcInvoker rpcInvoker : temporaryInvokers) {
                if (!rpcInvoker.isTemporary()) continue;
                long lastActiveTime = rpcInvoker.getLastActiveTime();
                long now = System.currentTimeMillis();
                long duration = now - lastActiveTime;
                if (duration < rpcInvoker.getDestroyTime()) continue;
                QRpcSystem.this.removeInvoker(rpcInvoker.getId());
            }
        }
    }
}

