/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.rpc.handler;

import com.kingdee.bos.qing.common.rpc.client.IQRpcInvokeResultGroupFuture;
import com.kingdee.bos.qing.common.rpc.codec.CodecProtocol;
import com.kingdee.bos.qing.common.rpc.codec.serialization.SerializationType;
import com.kingdee.bos.qing.common.rpc.model.QRpcHeartBeat;
import com.kingdee.bos.qing.common.rpc.model.QRpcInvokeResult;
import com.kingdee.bos.qing.common.rpc.model.QRpcMessage;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleStateEvent;

public class MessageClientHandler
extends ChannelInboundHandlerAdapter {
    private IQRpcInvokeResultGroupFuture qRpcInvokeResultReceiver;
    private byte rpcVersion;

    public MessageClientHandler(IQRpcInvokeResultGroupFuture qRpcInvokeResultReceiver, byte rpcVersion) {
        this.qRpcInvokeResultReceiver = qRpcInvokeResultReceiver;
        this.rpcVersion = rpcVersion;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        QRpcMessage rpcMessage = (QRpcMessage)msg;
        byte msgType = rpcMessage.getMsgType();
        switch (msgType) {
            case 0: {
                QRpcInvokeResult resp = rpcMessage.getTypeMsg(QRpcInvokeResult.class);
                this.qRpcInvokeResultReceiver.setFutureResult(rpcMessage.getSeq(), resp);
                break;
            }
            default: {
                ctx.fireChannelRead(msg);
            }
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        IdleStateEvent event;
        if (evt instanceof IdleStateEvent && (event = (IdleStateEvent)evt).state() == IdleStateEvent.WRITER_IDLE_STATE_EVENT.state()) {
            byte compressType = CodecProtocol.getCompressionType().getType();
            byte serializeType = this.rpcVersion == 12 ? SerializationType.KRYO_V2.getType() : SerializationType.KRYO.getType();
            QRpcMessage hello = new QRpcMessage(-1L, compressType, serializeType, this.rpcVersion, new QRpcHeartBeat());
            ctx.writeAndFlush((Object)hello);
        }
        super.userEventTriggered(ctx, evt);
    }
}

