/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.meta;

import com.kingdee.bos.qing.datasource.meta.DSMetaProperty;
import com.kingdee.bos.qing.datasource.meta.DSParentChildDimension;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.datasource.meta.view.AbstractDSViewItem;
import com.kingdee.bos.qing.datasource.meta.view.DSMetaEntitySubView;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DSMetaEntity {
    private String _name;
    private String _displayName;
    private String _parentName;
    private List<DSMetaProperty> _properties;
    private List<DSParentChildDimension> parentChildDimensions;
    private List<DSMetaEntitySubView> subViews = null;
    private List<AbstractDSViewItem> viewItems = null;

    public static DSMetaEntity createInstanceForSingleMode(List<DSMetaProperty> properties) {
        DSMetaEntity inst = new DSMetaEntity(null, null);
        inst.setProperties(properties);
        return inst;
    }

    public DSMetaEntity(String name, String displayName) {
        this._name = name;
        this._displayName = displayName;
    }

    public String getName() {
        return this._name;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public String getParentName() {
        return this._parentName;
    }

    public void setParentName(String parentName) {
        this._parentName = parentName;
    }

    public List<DSMetaProperty> getProperties() {
        if (this._properties == null) {
            this._properties = new ArrayList<DSMetaProperty>();
        }
        return this._properties;
    }

    public void setProperties(List<DSMetaProperty> properties) {
        this._properties = properties;
    }

    public void setParentChildDimensions(List<DSParentChildDimension> pcds) {
        this.parentChildDimensions = pcds;
    }

    public List<DSParentChildDimension> getParentChildDimensions() {
        return this.parentChildDimensions;
    }

    public Set<String> createProperyNameSet() {
        HashSet<String> nameSet = new HashSet<String>(this.getProperties().size());
        for (DSMetaProperty dsMetaProperty : this.getProperties()) {
            nameSet.add(dsMetaProperty.getName());
        }
        return nameSet;
    }

    public void setSubViews(List<DSMetaEntitySubView> subViews) {
        this.subViews = subViews;
    }

    public List<DSMetaEntitySubView> getSubViews() {
        if (this.subViews == null) {
            this.subViews = new ArrayList<DSMetaEntitySubView>();
        }
        return this.subViews;
    }

    public void setViewItems(List<AbstractDSViewItem> items) {
        this.viewItems = items;
    }

    public List<AbstractDSViewItem> getViewItems() {
        if (this.viewItems == null) {
            this.viewItems = new ArrayList<AbstractDSViewItem>();
        }
        return this.viewItems;
    }

    public MetaInfo toMetaInfo() {
        MetaInfo metaInfo = new MetaInfo();
        for (DSMetaProperty dsMetaProperty : this._properties) {
            metaInfo.addField(dsMetaProperty.getName(), dsMetaProperty.getDisplayName(), dsMetaProperty.getDataType(), dsMetaProperty.isHide());
        }
        metaInfo.setDsParentChildDimensions(this.parentChildDimensions);
        metaInfo.setSubViews(this.subViews);
        metaInfo.setViewItems(this.viewItems);
        return metaInfo;
    }
}

