/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.exceptionlog.dao;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.exceptionlog.model.ExceptionLog;
import com.kingdee.bos.qing.exceptionlog.model.ExceptionLogBizTypeEnum;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;

public class ExceptionLogDao {
    private IDBExcuter dbExcuter;

    public ExceptionLogDao(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void insert(ExceptionLog exceptionLog) throws AbstractQingIntegratedException, SQLException {
        String logId = this.dbExcuter.genStringId("T_QING_EXCEPTION_LOG");
        exceptionLog.setId(logId);
        this.insertExceptionLog(exceptionLog);
        this.insertExceptionLogStackTrace(logId, exceptionLog.getErrorStackTrace());
    }

    private void insertExceptionLog(ExceptionLog exceptionLog) throws AbstractQingIntegratedException, SQLException {
        String errorMessage;
        Object[] params = new Object[5];
        params[0] = exceptionLog.getId();
        params[1] = exceptionLog.getBizId();
        params[2] = Character.valueOf(exceptionLog.getBizTypeEnum().getBizType());
        params[3] = exceptionLog.getErrorCode();
        String string = errorMessage = StringUtils.isNotEmpty(exceptionLog.getErrorMessage()) ? exceptionLog.getErrorMessage() : " ";
        if (errorMessage.length() > 33) {
            errorMessage = errorMessage.substring(0, 33);
        }
        params[4] = errorMessage;
        this.dbExcuter.execute("INSERT INTO T_QING_EXCEPTION_LOG (FID, FBIZID, FBIZTYPE, FERRORCODE, FERRORMESSAGE) VALUES (?, ?, ?, ?, ?)", params);
    }

    private void insertExceptionLogStackTrace(String logId, String errorStackTrace) throws AbstractQingIntegratedException, SQLException {
        byte[] errorStackTraceBytes;
        int length;
        if (StringUtils.isNotBlank(errorStackTrace) && (length = (errorStackTraceBytes = errorStackTrace.getBytes()).length) > 0) {
            int count = length % 32768 == 0 ? length / 32768 : length / 32768 + 1;
            int contentSize = 0;
            int offset = 0;
            ArrayList<Object[]> paramsContentList = new ArrayList<Object[]>(count);
            for (int i = 0; i < count; ++i) {
                Object[] paramsContents = new Object[4];
                contentSize = length - i * 32768 > 32768 ? 32768 : length - i * 32768;
                String fidContent = this.dbExcuter.genStringId("T_QING_EXCEPTION_LOG_CONT");
                paramsContents[0] = fidContent;
                paramsContents[1] = logId;
                paramsContents[2] = i;
                paramsContents[3] = this.dbExcuter.createSqlParameterBytes(errorStackTraceBytes, offset, contentSize);
                offset += contentSize;
                paramsContentList.add(paramsContents);
            }
            this.dbExcuter.executeBatch("INSERT INTO T_QING_EXCEPTION_LOG_CONT (FID, FLOGID, FINDEX, FERRORSTACKTRACE) VALUES (?, ?, ?, ?)", paramsContentList);
        }
    }

    public ExceptionLog selectByBizIdAndBizType(String bizId, ExceptionLogBizTypeEnum bizTypeEnum) throws AbstractQingIntegratedException, SQLException {
        byte[] contentBytes;
        ExceptionLog exceptionLog = this.selectExceptionLogByBizIdAndBizType(bizId, bizTypeEnum);
        if (exceptionLog != null && (contentBytes = this.selectExceptionLogContentByLogId(exceptionLog.getId())) != null) {
            exceptionLog.setErrorStackTrace(new String(contentBytes));
        }
        return exceptionLog;
    }

    private ExceptionLog selectExceptionLogByBizIdAndBizType(String bizId, ExceptionLogBizTypeEnum bizTypeEnum) throws AbstractQingIntegratedException, SQLException {
        return this.dbExcuter.query("SELECT FID, FBIZID, FBIZTYPE, FERRORCODE, FERRORMESSAGE FROM T_QING_EXCEPTION_LOG WHERE FBIZID=? AND FBIZTYPE=?", new Object[]{bizId, Character.valueOf(bizTypeEnum.getBizType())}, new ResultHandler<ExceptionLog>(){

            @Override
            public ExceptionLog handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    ExceptionLog exceptionLog = new ExceptionLog();
                    exceptionLog.setId(rs.getString("FID"));
                    exceptionLog.setBizId(rs.getString("FBIZID"));
                    exceptionLog.setBizTypeEnum(ExceptionLogBizTypeEnum.fromPersistance(rs.getString("FBIZTYPE").charAt(0)));
                    exceptionLog.setErrorCode(rs.getInt("FERRORCODE"));
                    exceptionLog.setErrorMessage(rs.getString("FERRORMESSAGE"));
                    return exceptionLog;
                }
                return null;
            }
        });
    }

    private byte[] selectExceptionLogContentByLogId(String logId) throws AbstractQingIntegratedException, SQLException {
        return this.dbExcuter.query("SELECT FERRORSTACKTRACE FROM T_QING_EXCEPTION_LOG_CONT WHERE FLOGID=? ORDER BY FINDEX ASC", new Object[]{logId}, new ResultHandler<byte[]>(){

            @Override
            public byte[] handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    do {
                        try {
                            os.write(rs.getBytes("FERRORSTACKTRACE"));
                        }
                        catch (IOException e) {
                            LogUtil.error("IOException", e);
                        }
                    } while (rs.next());
                    return os.toByteArray();
                }
                return null;
            }
        });
    }

    public void delete(String bizId, ExceptionLogBizTypeEnum bizTypeEnum) throws AbstractQingIntegratedException, SQLException {
        ExceptionLog exceptionLog = this.selectExceptionLogByBizIdAndBizType(bizId, bizTypeEnum);
        this.dbExcuter.execute("DELETE FROM T_QING_EXCEPTION_LOG WHERE FBIZID=? AND FBIZTYPE=?", new Object[]{bizId, Character.valueOf(bizTypeEnum.getBizType())});
        if (exceptionLog != null) {
            this.dbExcuter.execute("DELETE FROM T_QING_EXCEPTION_LOG_CONT WHERE FLOGID=?", new Object[]{exceptionLog.getId()});
        }
    }

    public void deleteScheduleExceptionLog(Date executeTime) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("DELETE FROM T_QING_EXCEPTION_LOG_CONT WHERE FLOGID IN (SELECT EL.FID FROM T_QING_EXCEPTION_LOG EL JOIN T_QING_SCHEDULE_EXECUTE SE ON SE.FID = EL.FBIZID WHERE SE.FEXECUTETIME < ?)", new Object[]{executeTime});
        this.dbExcuter.execute("DELETE FROM T_QING_EXCEPTION_LOG WHERE FBIZID IN (SELECT FID FROM T_QING_SCHEDULE_EXECUTE WHERE FEXECUTETIME < ?)", new Object[]{executeTime});
    }
}

