/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.msgbus.dispatch;

import com.kingdee.bos.qing.msgbus.deliver.MsgDelivererHelper;
import com.kingdee.bos.qing.msgbus.model.msgpack.MsgPackToDeliver;
import com.kingdee.bos.qing.msgbus.sort.MsgSorter;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;

public class MessageDispatchTask
implements Runnable {
    private LinkedBlockingQueue<String> msgPackIds = new LinkedBlockingQueue();
    private volatile boolean running = false;
    private volatile boolean submitted = false;
    private String sessionId;
    private long lastRunTimestamp = System.currentTimeMillis();
    private static long timeout = 1800000L;

    public MessageDispatchTask(String sessionId) {
        this.sessionId = sessionId;
    }

    public void addPackId(String msgPackId) {
        this.msgPackIds.offer(msgPackId);
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isSubmitted() {
        return this.submitted;
    }

    public void setSubmitted(boolean submitted) {
        this.submitted = submitted;
    }

    public boolean isUseless() {
        if (!this.running) {
            return System.currentTimeMillis() - this.lastRunTimestamp > timeout;
        }
        return false;
    }

    @Override
    public void run() {
        this.start();
        try {
            do {
                this.dispatch();
            } while (!this.msgPackIds.isEmpty());
        }
        catch (Exception e) {
            LogUtil.error("Qing msg bus dispatch message failed", e);
        }
        finally {
            this.end();
        }
    }

    private void start() {
        this.running = true;
    }

    private void end() {
        this.running = false;
        this.submitted = false;
        this.lastRunTimestamp = System.currentTimeMillis();
    }

    public void dispatch() {
        MsgSorter msgSorter = new MsgSorter(this.sessionId);
        ArrayList<MsgPackToDeliver> msgPacks = new ArrayList<MsgPackToDeliver>(10);
        while (!this.msgPackIds.isEmpty()) {
            String msgPackId = this.msgPackIds.poll();
            msgPacks.addAll(msgSorter.sortMsgPack(msgPackId));
        }
        MsgDelivererHelper.deliver(msgPacks);
    }
}

