/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.response;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.common.framework.server.task.DuplicatedWaitingWorkException;
import com.kingdee.bos.qing.common.framework.web.ServerFileAccesser;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IWriteCall;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.response.AbstractResponseWrap;
import com.kingdee.bos.qing.response.IResponseStrategy;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.IOUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StackTraceUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class ResponseErrorWrap
extends AbstractResponseWrap {
    private static final long serialVersionUID = 2453304714744782297L;
    private int errorCode;
    private String errorMessage;
    private String errorStackMessage;
    private String errorStackMessageFile;

    public ResponseErrorWrap(int errorCode, String errorMessage) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public ResponseErrorWrap(int errorCode, String errorMessage, Throwable exception) {
        AbstractQingException e = this.getAbstractQingException(exception);
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.handleDuplicatedWorkWaitAndStackTrace(exception);
        LogUtil.error(e.getMessage(), e);
    }

    public ResponseErrorWrap(String errorMessage, Throwable exception) {
        AbstractQingException e = this.getAbstractQingException(exception);
        this.errorCode = e.getErrorCode();
        this.errorMessage = errorMessage;
        this.handleDuplicatedWorkWaitAndStackTrace(exception);
        LogUtil.error(e.getMessage(), e);
    }

    public ResponseErrorWrap(Throwable exception) {
        AbstractQingException e = this.getAbstractQingException(exception);
        this.errorCode = e.getErrorCode();
        this.errorMessage = e.getMessage();
        this.handleDuplicatedWorkWaitAndStackTrace(exception);
        LogUtil.error(e.getMessage(), e);
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorStackMessage() {
        return this.errorStackMessage;
    }

    public void setErrorStackMessage(String errorStackMessage) {
        this.errorStackMessage = errorStackMessage;
    }

    public String getErrorStackMessageFile() {
        return this.errorStackMessageFile;
    }

    private AbstractQingException getAbstractQingException(Throwable exception) {
        AbstractQingException e = null;
        e = !(exception instanceof AbstractQingException) ? new IntegratedRuntimeException(exception) : (AbstractQingException)exception;
        return e;
    }

    private void handleDuplicatedWorkWaitAndStackTrace(Throwable exception) {
        if (exception instanceof DuplicatedWaitingWorkException) {
            throw (DuplicatedWaitingWorkException)exception;
        }
        boolean isWrapStackTrace = true;
        IResponseStrategy responseStrategy = CustomStrategyRegistrar.getStrategy(IResponseStrategy.class);
        if (responseStrategy != null && !responseStrategy.isShowStackTrace()) {
            isWrapStackTrace = false;
        }
        if (isWrapStackTrace) {
            this.errorStackMessage = StackTraceUtil.getStackTrace(exception);
        }
    }

    @Override
    public void saveToCacheFile() {
        if (this.errorStackMessage != null) {
            IQingFile qingFile = FileFactory.newTempFile(QingTempFileType.DS_CACHE);
            try {
                qingFile.write(new IWriteCall(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void call(OutputStream outputStream) throws IOException {
                        byte[] content = ResponseErrorWrap.this.errorStackMessage.getBytes(StandardCharsets.UTF_8);
                        ByteArrayInputStream inputStream = new ByteArrayInputStream(content);
                        try {
                            IOUtil.copy(inputStream, outputStream);
                        }
                        catch (Throwable throwable) {
                            CloseUtil.close(inputStream);
                            throw throwable;
                        }
                        CloseUtil.close(inputStream);
                    }
                }, true);
                this.errorStackMessageFile = qingFile.getName();
                this.errorStackMessage = null;
            }
            catch (IOException e) {
                LogUtil.error(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadFromCacheFile(QingContext qingContext) {
        if (this.errorStackMessage == null && this.errorStackMessageFile != null) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                ServerFileAccesser.loadFile(qingContext, "qing", this.errorStackMessageFile, QingTempFileType.DS_CACHE, outputStream);
                this.errorStackMessage = new String(outputStream.toByteArray(), StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                LogUtil.error(e.getMessage(), e);
            }
            finally {
                this.errorStackMessageFile = null;
            }
        }
    }

    @Override
    public void deleteCacheFile(QingContext qingContext) {
        try {
            ServerFileAccesser.deleteFile(qingContext, "qing", this.errorStackMessageFile, QingTempFileType.DS_CACHE.getTypeIndex());
        }
        catch (AbstractQingException e) {
            LogUtil.error(e.getMessage(), e);
        }
    }
}

