/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.util;

import com.kingdee.bos.qing.common.context.IQingContextable;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.common.framework.server.task.DuplicatedWaitingWorkException;
import com.kingdee.bos.qing.domain.progress.ProcessingFeedback;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MethodInvokeUtil {
    private static Map<Class<?>, IInterfaceInjector<?>> interfaceInjectorMap = new HashMap();
    private static Map<Class<?>, IMethodAnnotationInjector<?>> methodAnnotationInjectorMap = new HashMap();
    private static Map<String, Method> serviceMethodMap;

    public static Object invoke(QingContext context, Object service, String methodName, Object ... parameters) throws AbstractQingException {
        ProcessingFeedback.initDefaultHandler();
        Method method = MethodInvokeUtil.reflectGetMethod(service.getClass(), methodName, parameters == null ? 0 : parameters.length);
        if (method == null && (method = MethodInvokeUtil.reflectGetMethod(service.getClass(), "invoke", parameters == null ? 0 : parameters.length)) == null) {
            throw new IntegratedRuntimeException("could not foud method " + methodName + " in " + service.getClass().getName());
        }
        MethodInvokeUtil.interfaceInject(context, service, parameters);
        MethodInvokeUtil.annotationInject(context, service, method, parameters);
        return MethodInvokeUtil.reflectInvokeMethod(service, method, parameters);
    }

    private static Object reflectInvokeMethod(Object service, Method method, Object ... parameters) throws AbstractQingException {
        try {
            return method.invoke(service, parameters);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getTargetException();
            if (cause instanceof AbstractQingException) {
                throw (AbstractQingException)cause;
            }
            if (cause instanceof DuplicatedWaitingWorkException) {
                throw (DuplicatedWaitingWorkException)cause;
            }
            throw new IntegratedRuntimeException("invoke method " + method.getName() + " in " + service.getClass().getName(), ex);
        }
        catch (Exception ex) {
            throw new IntegratedRuntimeException("invoke method " + method.getName() + " in " + service.getClass().getName(), ex);
        }
    }

    public static void annotationInject(QingContext context, Object service, Method method, Object[] parameters) throws AbstractQingException {
        Annotation[] annotations = method.getAnnotations();
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                Class<? extends Annotation> annotationClass = annotation.annotationType();
                IMethodAnnotationInjector<?> methodAnnotationInjector = methodAnnotationInjectorMap.get(annotationClass);
                if (methodAnnotationInjector == null) continue;
                methodAnnotationInjector.injector(context, service, method, annotation, parameters);
            }
        }
    }

    public static <T> void registInterfaceInjector(Class<T> interfaceClass, IInterfaceInjector<T> interfaceInjector) {
        interfaceInjectorMap.put(interfaceClass, interfaceInjector);
    }

    public static <T> void registMethodAnnotationInjector(Class<T> interfaceClass, IMethodAnnotationInjector<T> methodAnnotationInjector) {
        methodAnnotationInjectorMap.put(interfaceClass, methodAnnotationInjector);
    }

    public static void interfaceInject(QingContext context, Object service, Object ... parameters) throws AbstractQingException {
        Class<?> serviceClass = service.getClass();
        while (!"java.lang.Object".equals(serviceClass.getName())) {
            Class<?>[] interfaces = serviceClass.getInterfaces();
            if (interfaces != null) {
                for (Class<?> interfaceClass : interfaces) {
                    IInterfaceInjector<?> interfaceInjector = interfaceInjectorMap.get(interfaceClass);
                    if (interfaceInjector == null) continue;
                    interfaceInjector.injector(context, service, parameters);
                }
            }
            serviceClass = serviceClass.getSuperclass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Method reflectGetMethod(Class<?> clazz, String method, int paramterLength) {
        String key = clazz.getName() + '#' + method + '#' + paramterLength;
        Method serviceMethod = serviceMethodMap.get(key);
        if (serviceMethod == null) {
            Map<String, Method> map = serviceMethodMap;
            synchronized (map) {
                serviceMethod = serviceMethodMap.get(key);
                if (serviceMethod == null) {
                    for (Method m : clazz.getMethods()) {
                        if (!m.getName().equalsIgnoreCase(method) || m.getParameterTypes().length != paramterLength) continue;
                        serviceMethod = m;
                        serviceMethodMap.put(key, serviceMethod);
                        break;
                    }
                }
            }
        }
        return serviceMethod;
    }

    public static Object invoke(Object service, String methodName, Object ... parameters) throws Throwable {
        Method method = MethodInvokeUtil.reflectGetMethod(service.getClass(), methodName, parameters == null ? 0 : parameters.length);
        try {
            return method.invoke(service, parameters);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    static {
        interfaceInjectorMap.put(IQingContextable.class, new QingContextInjector());
        serviceMethodMap = new ConcurrentHashMap<String, Method>();
    }

    private static class QingContextInjector
    implements IInterfaceInjector<IQingContextable> {
        private QingContextInjector() {
        }

        @Override
        public void injector(QingContext qingContext, IQingContextable service, Object ... parameters) {
            QingContext.setCurrent(qingContext);
            service.setQingContext(qingContext);
        }
    }

    public static interface IMethodAnnotationInjector<T> {
        public void injector(QingContext var1, Object var2, Method var3, T var4, Object ... var5) throws AbstractQingException;
    }

    public static interface IInterfaceInjector<T> {
        public void injector(QingContext var1, T var2, Object ... var3) throws AbstractQingException;
    }
}

