/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.util;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.context.QingContextCallable;
import com.kingdee.bos.qing.common.rpc.common.QRpcConfiguration;
import com.kingdee.bos.qing.common.thread.ListenableFutureCallback;
import com.kingdee.bos.qing.common.thread.ListenableFutureTask;
import com.kingdee.bos.qing.common.thread.TaskQueue;
import com.kingdee.bos.qing.common.thread.ThreadPoolExecutor;
import com.kingdee.bos.qing.common.thread.ThreadPoolMonitor;
import com.kingdee.bos.qing.util.SystemPropertyUtil;
import java.util.Locale;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadPoolManage {
    public static final String QING_MEMORY_MONITOR_THREAD = "Qing-Memory-Monitor-Thread";
    public static final String QING_JOIN_TASK_SCHEDULE_THREAD = "Qing-Join-Task-Schedule-Thread";
    public static final String QING_JOIN_TASK_EVENT_THREAD = "Qing-Join-Task-Event-Thread";
    public static final String QING_JOIN_TASK_RETRY_THREAD = "Qing-Join-Task-Retry-Thread";
    public static final String QING_MONITOR_BUCKETSTATE_CHECK_THREAD = "Qing-Monitor-BucketState-Check-Thread";
    public static final String QING_SHARE_SOURCE_PROGRESS_UPDATE_THREAD = "Qing-Share-Source-Progress-Update-Thread";
    public static final String QING_JOIN_TASK_WORKER_THREAD = "Qing-Join-Task-Worker-Thread";
    public static final String QING_INVOKE_HEALTH_CHECK_THREAD = "Qing-Invoke-Health-Check-Thread";
    private static ScheduledExecutorService scheduledExecutorService = null;
    private static volatile ConcurrentHashMap<QingThreadPoolName, ExecutorService> QINGPOOLMAP = new ConcurrentHashMap();
    private static volatile IExecutorServiceWraper executorServiceWarper;

    private static ScheduledExecutorService getScheduleExecutorService() {
        if (scheduledExecutorService == null) {
            scheduledExecutorService = new ScheduledThreadPoolExecutor(SystemPropertyUtil.getInt("qing.threadPool.globalSchedule.corePoolSize", 3), new NamedThreadFactory("Qing-Global-Schedule-Thread"));
        }
        return scheduledExecutorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ExecutorService getExecutorService(QingThreadPoolName qingThreadPoolName) {
        ExecutorService executorService = QINGPOOLMAP.get((Object)qingThreadPoolName);
        if (executorService != null) return executorService;
        Class<ThreadPoolManage> clazz = ThreadPoolManage.class;
        synchronized (ThreadPoolManage.class) {
            executorService = QINGPOOLMAP.get((Object)qingThreadPoolName);
            if (executorService != null) return executorService;
            TaskQueue taskQueue = new TaskQueue();
            ThreadPoolExecutor threadPoolExecutor = null;
            RejectedExecutionHandler rejectedExecutionHandler = qingThreadPoolName.getRejectedExecutionHandler();
            if (rejectedExecutionHandler == null) {
                threadPoolExecutor = new ThreadPoolExecutor(qingThreadPoolName.getCorePoolSize(), qingThreadPoolName.getMaximumPoolSize(), qingThreadPoolName.getKeepAliveTime(), qingThreadPoolName.getUnit(), (BlockingQueue<Runnable>)taskQueue, new NamedThreadFactory(qingThreadPoolName.getPoolName()));
            } else {
                taskQueue = new TaskQueue(QingThreadPoolName.QING_IO_WORKER_TASK_HANDLER.maximumPoolSize);
                threadPoolExecutor = new ThreadPoolExecutor(qingThreadPoolName.getCorePoolSize(), qingThreadPoolName.getMaximumPoolSize(), qingThreadPoolName.getKeepAliveTime(), qingThreadPoolName.getUnit(), taskQueue, new NamedThreadFactory(qingThreadPoolName.getPoolName()), rejectedExecutionHandler);
            }
            taskQueue.setParent(threadPoolExecutor);
            ThreadPoolMonitor.getInstance().initThreadPoolStatistic(qingThreadPoolName, threadPoolExecutor);
            executorService = threadPoolExecutor;
            if (executorServiceWarper != null && qingThreadPoolName.wrapExecutor) {
                executorService = executorServiceWarper.wrap(executorService);
            }
            QINGPOOLMAP.put(qingThreadPoolName, executorService);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return executorService;
        }
    }

    public static synchronized void setExecutorService(IExecutorServiceWraper executorServiceWarper) {
        if (ThreadPoolManage.executorServiceWarper == null) {
            ThreadPoolManage.executorServiceWarper = executorServiceWarper;
        }
    }

    public static <T> Future<T> excuteThreadWithContext(QingThreadPoolName qingPoolName, Callable<T> callable, QingContext context) {
        return ThreadPoolManage.getExecutorService(qingPoolName).submit(new QingContextCallable<T>(callable, context));
    }

    public static <T> Future<?> excuteThreadWithContextAndCallback(QingThreadPoolName qingPoolName, QingContext context, Callable<T> callable, ListenableFutureCallback<T> callback) {
        return ThreadPoolManage.getExecutorService(qingPoolName).submit(new ListenableFutureTask<T>(context, callable, callback));
    }

    public static Future<?> submit(QingThreadPoolName qingPoolName, Runnable callable) {
        Runnable wrapRunnable = qingPoolName.wrapExecutor ? ThreadPoolManage.wrapRunnable(callable) : callable;
        return ThreadPoolManage.getExecutorService(qingPoolName).submit(wrapRunnable);
    }

    public static ScheduledFuture<?> schedule(Runnable runnable, long delay, TimeUnit unit) {
        Runnable wrapRunnable = ThreadPoolManage.wrapRunnable(runnable);
        return ThreadPoolManage.getScheduleExecutorService().schedule(wrapRunnable, delay, unit);
    }

    public static ScheduledFuture<?> scheduleAtFixRate(Runnable runnable, long initialDelay, long period, TimeUnit unit) {
        Runnable wrapRunnable = ThreadPoolManage.wrapRunnable(runnable);
        return ThreadPoolManage.getScheduleExecutorService().scheduleAtFixedRate(wrapRunnable, initialDelay, period, unit);
    }

    public static ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long initialDelay, long period, TimeUnit unit) {
        Runnable wrapRunnable = ThreadPoolManage.wrapRunnable(runnable);
        return ThreadPoolManage.getScheduleExecutorService().scheduleWithFixedDelay(wrapRunnable, initialDelay, period, unit);
    }

    public static Runnable wrapRunnable(Runnable runnable) {
        if (executorServiceWarper != null) {
            return executorServiceWarper.wrapRunnable(runnable);
        }
        return runnable;
    }

    public static class NamedThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private static final String NAME_PATTERN = "%s-thread";
        private final String threadNamePrefix;
        private boolean isDaemon = false;

        public NamedThreadFactory(String threadNamePrefix) {
            this(threadNamePrefix, false);
        }

        public NamedThreadFactory(String threadNamePrefix, boolean daemon) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.threadNamePrefix = String.format(Locale.ROOT, NAME_PATTERN, NamedThreadFactory.checkPrefix(threadNamePrefix));
            this.isDaemon = daemon;
        }

        private static String checkPrefix(String prefix) {
            return prefix == null || prefix.length() == 0 ? "Qing" : prefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, String.format(Locale.ROOT, "%s-%d", this.threadNamePrefix, this.threadNumber.getAndIncrement()), 0L);
            t.setDaemon(this.isDaemon);
            t.setPriority(5);
            return t;
        }
    }

    public static interface IExecutorServiceWraper {
        public ExecutorService wrap(ExecutorService var1);

        public Runnable wrapRunnable(Runnable var1);
    }

    public static enum QingThreadPoolName {
        QING_RUN_IN_BACKGROUND_HANDLER("Qing-Run-In-Background-Task", SystemPropertyUtil.getInt("qing.threadPool.runInBackground.corePoolSize", 0), SystemPropertyUtil.getInt("qing.threadPool.runInBackground.maximumPoolSize", 16), SystemPropertyUtil.getLong("qing.threadPool.runInBackground.keepAliveTime", 60L), TimeUnit.SECONDS),
        QING_SHORT_TIME_TASK_HANDLER("Qing-Short-Time-Task", SystemPropertyUtil.getInt("qing.threadPool.shortTimeTask.corePoolSize", 8), SystemPropertyUtil.getInt("qing.threadPool.shortTimeTask.maximumPoolSize", 16), SystemPropertyUtil.getLong("qing.threadPool.shortTimeTask.keepAliveTime", 60L), TimeUnit.SECONDS),
        QING_LONG_TIME_TASK_HANDLER("Qing-Long-Time-Task", SystemPropertyUtil.getInt("qing.threadPool.longTimeTask.corePoolSize", 8), SystemPropertyUtil.getInt("qing.threadPool.longTimeTask.maximumPoolSize", 16), SystemPropertyUtil.getLong("qing.threadPool.longTimeTask.keepAliveTime", 60L), TimeUnit.SECONDS),
        QING_IO_MASTER_TASK_HANDLER("Qing-IO-Master-Task", SystemPropertyUtil.getInt("qing.threadPool.IOMasterTask.corePoolSize", 8), SystemPropertyUtil.getInt("qing.threadPool.IOMasterTask.maximumPoolSize", 48), SystemPropertyUtil.getLong("qing.threadPool.IOMasterTask.keepAliveTime", 60L), TimeUnit.SECONDS),
        QING_IO_WORKER_TASK_HANDLER("Qing-IO-Worker-Task", SystemPropertyUtil.getInt("qing.threadPool.IOWorkerTask.corePoolSize", 0), SystemPropertyUtil.getInt("qing.threadPool.IOWorkerTask.maximumPoolSize", 16), SystemPropertyUtil.getLong("qing.threadPool.IOWorkerTask.keepAliveTime", 60L), TimeUnit.SECONDS, new ThreadPoolExecutor.AbortPolicy()),
        QING_RPT_EXEC_TASK_HANDLER("Qing-RPT-Exec-Task", SystemPropertyUtil.getInt("qing.threadPool.rptExeTask.corePoolSize", 5), SystemPropertyUtil.getInt("qing.threadPool.rptExeTask.maximumPoolSize", 20), SystemPropertyUtil.getLong("qing.threadPool.rptExeTask.keepAliveTime", 60L), TimeUnit.SECONDS),
        QING_MODELER_LONG_TIME_TASK_HANDLER("Qing-Modeler-Long-Time-Task", SystemPropertyUtil.getInt("qing.threadPool.modelerLongTimeTask.corePoolSize", 5), SystemPropertyUtil.getInt("qing.threadPool.modelerLongTimeTask.maximumPoolSize", 60), SystemPropertyUtil.getLong("qing.threadPool.modelerLongTimeTask.keepAliveTime", 60L), TimeUnit.SECONDS),
        QING_RPC_INVOKER_TASK_HANDLER("Qing-RPC-Invoker-Task", QRpcConfiguration.getRpcInvokerCoreThreadSize(), QRpcConfiguration.getRpcInvokerMaxThreadSize(), SystemPropertyUtil.getLong("qing.threadPool.rpcInvokerTask.keepAliveTime", 60L), TimeUnit.SECONDS, false);

        private String poolName;
        private int corePoolSize;
        private int maximumPoolSize;
        private long keepAliveTime;
        private TimeUnit unit;
        private RejectedExecutionHandler rejectedExecutionHandler;
        private boolean wrapExecutor = true;

        private QingThreadPoolName(String poolName, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, RejectedExecutionHandler rejectedExecutionHandler) {
            this.poolName = poolName;
            this.corePoolSize = corePoolSize;
            this.maximumPoolSize = maximumPoolSize;
            this.keepAliveTime = keepAliveTime;
            this.unit = unit;
            this.rejectedExecutionHandler = rejectedExecutionHandler;
        }

        private QingThreadPoolName(String poolName, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit) {
            this.poolName = poolName;
            this.corePoolSize = corePoolSize;
            this.maximumPoolSize = maximumPoolSize;
            this.keepAliveTime = keepAliveTime;
            this.unit = unit;
        }

        private QingThreadPoolName(String poolName, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, boolean wrapExecutor) {
            this.poolName = poolName;
            this.corePoolSize = corePoolSize;
            this.maximumPoolSize = maximumPoolSize;
            this.keepAliveTime = keepAliveTime;
            this.unit = unit;
            this.wrapExecutor = wrapExecutor;
        }

        public String getPoolName() {
            return this.poolName;
        }

        public int getCorePoolSize() {
            return this.corePoolSize;
        }

        public int getMaximumPoolSize() {
            return this.maximumPoolSize;
        }

        public long getKeepAliveTime() {
            return this.keepAliveTime;
        }

        public TimeUnit getUnit() {
            return this.unit;
        }

        public RejectedExecutionHandler getRejectedExecutionHandler() {
            return this.rejectedExecutionHandler;
        }
    }
}

