/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class W3cXmlUtil {
    private static final String FRATURE_DISALLOW_DOCTYPE_DECL = "http://apache.org/xml/features/disallow-doctype-decl";
    private static final String FRATURE_EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String FRATURE_EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    private static final String FRATURE_LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";

    private W3cXmlUtil() {
    }

    public static Document createDocument() {
        return W3cXmlUtil.createDocumentBuilder().newDocument();
    }

    public static Document read(InputStream stm) throws SAXException, IOException {
        InputSource source = new InputSource(stm);
        source.setEncoding("utf-8");
        return W3cXmlUtil.createDocumentBuilder().parse(source);
    }

    public static void write(Document doc, OutputStream stm) throws TransformerException {
        DOMSource domSource = new DOMSource(doc);
        StreamResult result = new StreamResult(new BufferedWriter(new OutputStreamWriter(stm)));
        Transformer transformer = W3cXmlUtil.createTransformer();
        transformer.setOutputProperty("encoding", "utf-8");
        transformer.transform(domSource, result);
    }

    private static DocumentBuilder createDocumentBuilder() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setFeature(FRATURE_DISALLOW_DOCTYPE_DECL, true);
            documentBuilderFactory.setFeature(FRATURE_EXTERNAL_GENERAL_ENTITIES, false);
            documentBuilderFactory.setFeature(FRATURE_EXTERNAL_PARAMETER_ENTITIES, false);
            documentBuilderFactory.setFeature(FRATURE_LOAD_EXTERNAL_DTD, false);
            documentBuilderFactory.setXIncludeAware(false);
            documentBuilderFactory.setExpandEntityReferences(false);
            return documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Transformer createTransformer() throws TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        transformerFactory.setAttribute("indent-number", 4);
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        return transformer;
    }

    public static Element getRoot(Document doc) {
        return doc.getDocumentElement();
    }

    public static Element getChild(Element parent, String name) {
        NodeList subNodes = parent.getChildNodes();
        int c = subNodes.getLength();
        for (int i = 0; i < c; ++i) {
            Element child;
            Node subNode = subNodes.item(i);
            if (!(subNode instanceof Element) || !name.equals((child = (Element)subNode).getTagName())) continue;
            return child;
        }
        return null;
    }

    public static List<Element> getChildren(Element parent, String name) {
        ArrayList<Element> children = new ArrayList<Element>();
        NodeList subNodes = parent.getChildNodes();
        int c = subNodes.getLength();
        for (int i = 0; i < c; ++i) {
            Element child;
            Node subNode = subNodes.item(i);
            if (!(subNode instanceof Element) || !name.equals((child = (Element)subNode).getTagName())) continue;
            children.add(child);
        }
        return children;
    }
}

