/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.qingshared.common.context;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.i18n.DefaultI18nContext;
import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.common.session.IQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.common.systemvar.SystemVarType;
import com.kingdee.bos.qing.common.systemvar.SystemVarValue;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.SystemPropertyUtil;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.mservice.qingshared.common.session.GlobalQingSessionImpl;
import kd.bos.mservice.qingshared.common.systemvarloader.BizOrgUnitIDValue;
import kd.bos.mservice.qingshared.common.systemvarloader.ChargeDeptAndSubSystemValue;
import kd.bos.mservice.qingshared.common.systemvarloader.ChargeDeptSystemValue;
import kd.bos.mservice.qingshared.common.systemvarloader.CurrentOrgNameValue;
import kd.bos.mservice.qingshared.common.systemvarloader.CurrentUserNameValue;
import kd.bos.mservice.qingshared.common.systemvarloader.DepartmentSystemVarValue;
import kd.bos.mservice.qingshared.common.systemvarloader.DeptAndSubSystemValue;

public class QingIntegratedContext
extends QingContext {
    private static final long serialVersionUID = 6224654600549344502L;
    private static String REQUESTCONTEXT_KEY = "requestContext";
    private RequestContext requestContext;

    public QingIntegratedContext() {
        this.requestContext = RequestContext.get();
        if (this.requestContext != null) {
            this.setSystemVars(Long.toString(this.requestContext.getCurrUserId()), this.requestContext.getOrgId());
            this.setAccountId(this.requestContext.getAccountId());
            this.setTenantId(this.requestContext.getTenantId());
            this.set(REQUESTCONTEXT_KEY, this.requestContext);
            this.setIi18nContext((II18nContext)new DefaultI18nContext(this.requestContext.getLang().getLocale()));
            this.setUserAgent(this.requestContext.getUserAgent());
            String sessionId = this.requestContext.getGlobalSessionId();
            this.setSessionID(sessionId);
            IQingSession qingSession = QingSessionUtil.getQingSession((String)sessionId);
            qingSession.login(sessionId);
        }
    }

    public QingIntegratedContext(RequestContext requestContext) {
        this.requestContext = requestContext;
        if (requestContext != null) {
            this.setSystemVars(Long.toString(requestContext.getCurrUserId()), requestContext.getOrgId());
            this.setAccountId(requestContext.getAccountId());
            this.setTenantId(requestContext.getTenantId());
            this.set(REQUESTCONTEXT_KEY, requestContext);
            this.setIi18nContext((II18nContext)new DefaultI18nContext(requestContext.getLang().getLocale()));
            this.setUserAgent(requestContext.getUserAgent());
            String sessionId = requestContext.getGlobalSessionId();
            this.setSessionID(sessionId);
        }
    }

    private void setSystemVars(String userId, long orgId) {
        try {
            long userIdL = Long.parseLong(userId);
            this.addSystemVar(SystemVarType.USER_ID, new SystemVarValue((Object)userIdL));
            this.addSystemVar(SystemVarType.USER_NAME, new CurrentUserNameValue(userIdL));
            this.addSystemVar(SystemVarType.ORG_ID, new SystemVarValue((Object)orgId));
            this.addSystemVar(SystemVarType.ORG_NAME, new CurrentOrgNameValue(orgId));
            this.addSystemVar(SystemVarType.DEPARTMENT_IDS, new DepartmentSystemVarValue(userIdL));
            this.addSystemVar(SystemVarType.DEPARTMENT_AND_SUBORDINATE_IDS, new DeptAndSubSystemValue(userId));
            this.addSystemVar(SystemVarType.CHARGE_DEPARTMENT_IDS, new ChargeDeptSystemValue(userId));
            this.addSystemVar(SystemVarType.CHARGE_DEPARTMENT_AND_SUBORDINATE_IDS, new ChargeDeptAndSubSystemValue(userId));
            this.addSystemVar(SystemVarType.BIZ_UNIT_ORGRANG_ID, new BizOrgUnitIDValue(userIdL));
            this.addSystemVar(SystemVarType.I18N, new SystemVarValue((Object)this.requestContext.getLang().getLocale()));
        }
        catch (Exception e) {
            LogUtil.error((String)"load user org info error", (Throwable)e);
        }
    }

    public void restor() {
        super.restor();
        RequestContextCreator.restoreForThreadPool((RequestContext)this.requestContext);
    }

    static {
        SystemPropertyUtil.setString((String)"qing.session.impl", (String)GlobalQingSessionImpl.class.getName());
    }
}

