/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.qingshared.common.lock;

import com.kingdee.bos.qing.common.lock.ILock;
import com.kingdee.bos.qing.common.lock.QingLockRequireException;
import com.kingdee.bos.qing.util.SystemPropertyUtil;
import kd.bos.context.RequestContext;
import kd.bos.dlock.DLock;

public class CosmicLock
implements ILock {
    private DLock dLock;

    public CosmicLock(String lockKey, RequestContext requestContext) {
        String accountKey = null == requestContext ? "qingGlobalLock" : requestContext.getAccountId();
        String appName = SystemPropertyUtil.getString((String)"appName", (String)"qing");
        String innerLock = lockKey + "-" + accountKey + "-" + appName;
        this.dLock = DLock.create((String)innerLock);
    }

    public void lock() throws QingLockRequireException, InterruptedException {
        try {
            this.dLock.lock();
        }
        catch (Throwable e) {
            throw new QingLockRequireException("lock failed", e);
        }
    }

    public boolean tryLock(long timeout) throws InterruptedException, QingLockRequireException {
        try {
            return this.dLock.tryLock(timeout);
        }
        catch (Throwable e) {
            throw new QingLockRequireException("lock failed", e);
        }
    }

    public boolean tryLock() throws QingLockRequireException, InterruptedException {
        try {
            return this.dLock.tryLock();
        }
        catch (Throwable e) {
            throw new QingLockRequireException("lock failed", e);
        }
    }

    public void unlock() {
        this.dLock.unlock();
    }
}

