/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.qingshared.common.login;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.exception.QingLicenseException;
import com.kingdee.bos.qing.common.session.IGlobalQingSession;
import com.kingdee.bos.qing.common.session.IQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.util.concurrent.TimeUnit;

public class LoginUtil {
    private static final String QING_OCCUPIED_USER_PREFIX = "QING_OCCUPIED_USER_";
    private static final String QING_CURRENT_SESSION_ONCE_OCCUPIED = "CURRENT_SESSION_ONCE_OCCUPIED";
    private static final String QING_OCCUPIED_TIME = "CURRENT_SESSION_OCCUPIED_TIME";

    private LoginUtil() {
    }

    private static void cacheSessionId(QingContext qingContext) {
        IGlobalQingSession globalSession = QingSessionUtil.getGlobalQingSessionImpl();
        String sessionId = qingContext.getSessionID();
        String userUid = LoginUtil.createUserUid(qingContext);
        globalSession.set(userUid, sessionId);
        globalSession.expireAfter(userUid, 5, TimeUnit.MINUTES);
        IQingSession session = QingSessionUtil.getQingSession((String)qingContext.getSessionID());
        session.set(QING_CURRENT_SESSION_ONCE_OCCUPIED, "true");
        session.set(QING_OCCUPIED_TIME, String.valueOf(System.currentTimeMillis()));
    }

    public static void checkReplicatedLogin(QingContext qingContext) throws QingLicenseException {
        if (LoginUtil.isLoginSomewhereElse(qingContext)) {
            throw QingLicenseException.ReplicatedLoginException;
        }
    }

    private static boolean isLoginSomewhereElse(QingContext qingContext) {
        IGlobalQingSession globalSession = QingSessionUtil.getGlobalQingSessionImpl();
        String currentSessionId = qingContext.getSessionID();
        String sessionIdInUse = globalSession.get(LoginUtil.createUserUid(qingContext));
        if (StringUtils.isBlank((CharSequence)sessionIdInUse)) {
            LoginUtil.cacheSessionId(qingContext);
            return false;
        }
        if (currentSessionId.equals(sessionIdInUse)) {
            LoginUtil.updateOccupiedTime(qingContext);
            return false;
        }
        if (LoginUtil.isSessionTimeout(sessionIdInUse)) {
            LoginUtil.cacheSessionId(qingContext);
            return false;
        }
        if (!LoginUtil.isOccupiedOnce(qingContext)) {
            LoginUtil.cacheSessionId(qingContext);
            return false;
        }
        return true;
    }

    private static boolean isOccupiedOnce(QingContext qingContext) {
        String currentSessionId = qingContext.getSessionID();
        IQingSession qingSession = QingSessionUtil.getQingSession((String)currentSessionId);
        String occupied = qingSession.get(QING_CURRENT_SESSION_ONCE_OCCUPIED);
        return "true".equals(occupied);
    }

    private static boolean isSessionTimeout(String sessionId) {
        IQingSession session = QingSessionUtil.getQingSession((String)sessionId);
        String occupiedTime = session.get(QING_OCCUPIED_TIME);
        return StringUtils.isEmpty((CharSequence)occupiedTime);
    }

    private static void updateOccupiedTime(QingContext qingContext) {
        IQingSession session = QingSessionUtil.getQingSession((String)qingContext.getSessionID());
        session.set(QING_OCCUPIED_TIME, String.valueOf(System.currentTimeMillis()));
    }

    private static String createUserUid(QingContext qingContext) {
        String accountId = qingContext.getAccountId();
        String userId = qingContext.getUserId();
        String tenantId = qingContext.getTenantId();
        StringBuilder sb = new StringBuilder();
        sb.append(QING_OCCUPIED_USER_PREFIX);
        sb.append(tenantId);
        sb.append("_");
        sb.append(accountId);
        sb.append("_");
        sb.append(userId);
        return sb.toString();
    }
}

