/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.qingshared.common.resourcelock;

import com.kingdee.bos.qing.common.framework.server.task.ServerRequestInvokeContext;
import com.kingdee.bos.qing.common.lock.IResourceLock;
import com.kingdee.bos.qing.common.lock.ResourceLockFactory;
import com.kingdee.bos.qing.common.lock.model.ClientResourceMapping;
import com.kingdee.bos.qing.common.lock.model.ResourceLockResult;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.IOException;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.mservice.qingshared.common.resourcelock.ResourceOccupancyManager;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.MutexFactory;

public class ResourceLockFactoryImpl
extends ResourceLockFactory {
    protected IResourceLock innerCreateResourceLock(String lockType, String lockKey, boolean isStrict) {
        return new ResourceLock(lockType, lockKey, isStrict);
    }

    private static class ResourceLock
    implements IResourceLock {
        private String lockType;
        private String lockKey;
        private boolean isStrict;

        public ResourceLock(String lockType, String lockKey, boolean isStrict) {
            this.isStrict = isStrict;
            this.lockType = lockType;
            this.lockKey = lockKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ResourceLockResult lock(String resourceId) {
            ResourceOccupancyManager.registReleaser();
            ResourceLockResult resourceLockResult = new ResourceLockResult();
            DataMutex dataMutex = null;
            try {
                dataMutex = MutexFactory.createDataMutex();
                boolean isSuccess = dataMutex.require(resourceId, this.lockType, this.lockType, this.lockKey, this.isStrict);
                resourceLockResult.setSuccessed(isSuccess);
                if (isSuccess) {
                    ServerRequestInvokeContext serverRequestInvokeContext = ServerRequestInvokeContext.get();
                    String clientID = serverRequestInvokeContext.getClientID();
                    ResourceOccupancyManager.AddMappingHandler addMappingHandler = ResourceOccupancyManager.getAddMappingHandler();
                    addMappingHandler.templateHandle(new ClientResourceMapping(clientID, resourceId, this.lockType, this.lockKey, this.isStrict));
                } else {
                    this.pasre(dataMutex.getLockInfo(), resourceLockResult);
                }
            }
            finally {
                if (dataMutex != null) {
                    try {
                        dataMutex.close();
                    }
                    catch (IOException e) {
                        LogUtil.error((String)e.getMessage(), (Throwable)e);
                    }
                }
            }
            return resourceLockResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unlock(String resourceId) {
            DataMutex dataMutex = null;
            try {
                dataMutex = MutexFactory.createDataMutex();
                ResourceOccupancyManager.RemoveMappingByResourceIdHandler removeMappingHandler = ResourceOccupancyManager.getRemoveMappingByResourceIdHandler();
                Map lockInfo = dataMutex.getLockInfo(resourceId, this.lockType, this.lockKey);
                if (lockInfo == null || lockInfo.size() == 0) {
                    removeMappingHandler.templateHandle(resourceId);
                    return;
                }
                boolean release = dataMutex.release(resourceId, this.lockType, this.lockKey);
                if (release) {
                    removeMappingHandler.templateHandle(resourceId);
                } else {
                    LogUtil.error((String)"resource lock release fail");
                }
            }
            finally {
                if (dataMutex != null) {
                    try {
                        dataMutex.close();
                    }
                    catch (IOException e) {
                        LogUtil.error((String)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }

        private void pasre(Map<String, String> lockInfo, ResourceLockResult lockResult) {
            String userIdStr;
            if (lockInfo != null && (userIdStr = lockInfo.get("userid")) != null) {
                lockResult.setUserId(userIdStr);
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bos_user");
                long userId = Long.parseLong(userIdStr);
                Map cacheUserObjs = BusinessDataReader.loadFromCache((Object[])new Object[]{userId}, (DynamicObjectType)dt);
                DynamicObject userObj = (DynamicObject)cacheUserObjs.get(userId);
                if (userObj != null) {
                    lockResult.setUserName(userObj.getString("name"));
                }
            }
        }
    }
}

