/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.qingshared.common.resourcelock;

import com.kingdee.bos.qing.common.cache.ISessionCacheable;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.framework.manage.ClientManager;
import com.kingdee.bos.qing.common.lock.ILock;
import com.kingdee.bos.qing.common.lock.IResourceLock;
import com.kingdee.bos.qing.common.lock.LockFactory;
import com.kingdee.bos.qing.common.lock.ResourceLockFactory;
import com.kingdee.bos.qing.common.lock.model.ClientResourceMapping;
import com.kingdee.bos.qing.common.lock.model.ResourceOccupancy;
import com.kingdee.bos.qing.common.session.IGlobalQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.ThreadPoolManage;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.mservice.qingshared.common.resourcelock.ResourceLockFactoryImpl;

public class ResourceOccupancyManager {
    private static boolean isFirstLock = true;
    private static final String CLIENT_PREFIX = "Qing.Client.";
    private static String releaserLockKey = "Qing.ResourceOccupancy.ReleaserLockKey";
    private static String resourceOccupancyLockKey = "Qing.ResourceOccupancy.LockKey";
    private static final String CLIENT_CLOSED_KEY_PAGE_RELEASE = "ClientClosed.PageRelease";
    private static AddMappingHandler addMappingHandler;
    private static RemoveMappingByResourceIdHandler removeMappingByResourceIdHandler;

    public static void regist() {
        ResourceLockFactory.regist((ResourceLockFactory)new ResourceLockFactoryImpl());
    }

    public static void registReleaser() {
        ILock lock = LockFactory.createGlobalLock((String)releaserLockKey);
        try {
            if (lock.tryLock()) {
                if (!isFirstLock) {
                    return;
                }
                ThreadPoolManage.scheduleWithFixedDelay((Runnable)new ReleaseTask(), (long)20L, (long)3L, (TimeUnit)TimeUnit.SECONDS);
                isFirstLock = false;
            }
        }
        catch (Exception e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    public static AddMappingHandler getAddMappingHandler() {
        if (addMappingHandler == null) {
            addMappingHandler = new AddMappingHandler();
        }
        return addMappingHandler;
    }

    public static RemoveMappingByResourceIdHandler getRemoveMappingByResourceIdHandler() {
        if (removeMappingByResourceIdHandler == null) {
            removeMappingByResourceIdHandler = new RemoveMappingByResourceIdHandler();
        }
        return removeMappingByResourceIdHandler;
    }

    private static IGlobalQingSession getGlobalQingSession() {
        return QingSessionUtil.getGlobalQingSessionImpl();
    }

    public static ResourceOccupancy getResourceOccupancy() {
        ResourceOccupancy resourceOccupancy = (ResourceOccupancy)ResourceOccupancyManager.getGlobalQingSession().getCache("Qing.ResourceOccupancy", ResourceOccupancy.class);
        if (resourceOccupancy == null) {
            resourceOccupancy = new ResourceOccupancy();
        }
        return resourceOccupancy;
    }

    public static void setResourceOccupancy(ISessionCacheable resourceOccupancy) {
        ResourceOccupancyManager.getGlobalQingSession().setCache(resourceOccupancy);
    }

    private static boolean isClientClosedByPageRelease(String clientId) {
        IGlobalQingSession globalQingSession = ResourceOccupancyManager.getGlobalQingSession();
        String clientKey = CLIENT_PREFIX + clientId;
        String isClientClosed = globalQingSession.hGet(clientKey, CLIENT_CLOSED_KEY_PAGE_RELEASE);
        return "TRUE".equals(isClientClosed);
    }

    private static class ReleaseTask
    implements Runnable {
        private QingContext qingContext;

        private ReleaseTask() {
        }

        public void setQingContext(QingContext qingContext) {
            this.qingContext = qingContext;
        }

        @Override
        public void run() {
            if (this.qingContext != null) {
                this.qingContext.restor();
            }
            this.releaseResource();
        }

        private void releaseResource() {
            ResourceOccupancy resourceOccupancy = (ResourceOccupancy)ResourceOccupancyManager.getGlobalQingSession().getCache("Qing.ResourceOccupancy", ResourceOccupancy.class);
            if (resourceOccupancy == null) {
                resourceOccupancy = new ResourceOccupancy();
            }
            Set clientResourceMappings = resourceOccupancy.getClientResourceMappings();
            for (ClientResourceMapping clientResourceMapping : clientResourceMappings) {
                boolean clientClosed = ClientManager.isClientClosed((String)clientResourceMapping.getClientId(), (boolean)true, null);
                boolean clientClosedByPageRelease = ResourceOccupancyManager.isClientClosedByPageRelease(clientResourceMapping.getClientId());
                if (!clientClosed && !clientClosedByPageRelease) continue;
                IResourceLock resourceLock = ResourceLockFactory.createLock((String)clientResourceMapping.getLockType(), (String)clientResourceMapping.getLockKey(), (boolean)clientResourceMapping.getIsStrict());
                resourceLock.unlock(clientResourceMapping.getResourceId());
                LogUtil.info((String)("Resource occupancy: schedule release resource successfully! The mapping: " + clientResourceMapping.toString()));
            }
        }
    }

    public static abstract class AbstractResourceOccupancyHandler {
        public abstract <T> void handle(ResourceOccupancy var1, T var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <T> void templateHandle(T t) {
            ILock lock = LockFactory.createGlobalLock((String)resourceOccupancyLockKey);
            try {
                if (lock.tryLock()) {
                    ResourceOccupancy resourceOccupancy = ResourceOccupancyManager.getResourceOccupancy();
                    this.handle(resourceOccupancy, t);
                    ResourceOccupancyManager.setResourceOccupancy((ISessionCacheable)resourceOccupancy);
                }
            }
            catch (Exception e) {
                LogUtil.error((String)e.getMessage(), (Throwable)e);
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }
    }

    public static class RemoveMappingByResourceIdHandler
    extends AbstractResourceOccupancyHandler {
        @Override
        public <T> void handle(ResourceOccupancy resourceOccupancy, T id) {
            String resourceId = (String)id;
            Set clientResourceMappings = resourceOccupancy.getClientResourceMappings();
            Iterator iterator = clientResourceMappings.iterator();
            while (iterator.hasNext()) {
                ClientResourceMapping clientResourceMapping = (ClientResourceMapping)iterator.next();
                if (!resourceId.equals(clientResourceMapping.getResourceId())) continue;
                iterator.remove();
                LogUtil.info((String)("Resource occupancy: remove client resource mapping successfully! The mapping: " + clientResourceMapping.toString()));
                break;
            }
        }
    }

    public static class AddMappingHandler
    extends AbstractResourceOccupancyHandler {
        @Override
        public <T> void handle(ResourceOccupancy resourceOccupancy, T resourceOccupation) {
            Set clientResourceMappings = resourceOccupancy.getClientResourceMappings();
            clientResourceMappings.add((ClientResourceMapping)resourceOccupation);
            LogUtil.info((String)("Resource occupancy: add client resource mapping successfully! The mapping: " + resourceOccupation.toString()));
        }
    }
}

