/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.qingshared.common.session;

import com.kingdee.bos.qing.common.lock.ILock;
import com.kingdee.bos.qing.common.lock.LockFactory;
import com.kingdee.bos.qing.common.session.AbstractGlobalQingSession;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.SystemPropertyUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;

public class GlobalQingSessionImpl
extends AbstractGlobalQingSession {
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("qing");

    private static String getKey(String key) {
        String clusterName = SystemPropertyUtil.getString((String)"clusterName");
        if (clusterName == null) {
            return key;
        }
        return clusterName + "." + key;
    }

    public void hSet(String key, String subKey, String value, int timeout, TimeUnit timeUnit) {
        key = GlobalQingSessionImpl.getKey(key);
        if (value == null) {
            cache.remove(key, subKey);
        } else {
            cache.put(key, subKey, value, timeout, timeUnit);
        }
    }

    public void set(String key, String value, int timeout, TimeUnit timeUnit) {
        key = GlobalQingSessionImpl.getKey(key);
        if (value == null) {
            cache.remove(key);
        } else {
            cache.put(key, (Object)value, timeout, timeUnit);
        }
    }

    public String hGet(String key, String subKey) {
        key = GlobalQingSessionImpl.getKey(key);
        return (String)cache.get(key, subKey);
    }

    public String get(String key) {
        key = GlobalQingSessionImpl.getKey(key);
        return (String)cache.get(key);
    }

    public byte[] getByteData(String key) {
        key = GlobalQingSessionImpl.getKey(key);
        return cache.getByteValue(key);
    }

    public void setBytesData(String key, byte[] datas, int timeoutSecond) {
        key = GlobalQingSessionImpl.getKey(key);
        cache.put(key, datas, timeoutSecond);
    }

    public void remove(String key) {
        key = GlobalQingSessionImpl.getKey(key);
        cache.remove(key);
    }

    public void hRemove(String key, String subKey) {
        key = GlobalQingSessionImpl.getKey(key);
        cache.remove(key, subKey);
    }

    public void expireAfter(String key, int paramInt, TimeUnit paramTimeUnit) {
        key = GlobalQingSessionImpl.getKey(key);
        cache.expireAfter(key, paramInt, paramTimeUnit);
    }

    public int addList(String key, String[] values, int timeout, TimeUnit timeUnit) {
        key = GlobalQingSessionImpl.getKey(key);
        return cache.addList(key, values, timeout, timeUnit);
    }

    public int insertList(String key, int index, String[] values) {
        key = GlobalQingSessionImpl.getKey(key);
        return cache.insertList(key, index, values);
    }

    public void setListObject(String key, int index, String value) {
        key = GlobalQingSessionImpl.getKey(key);
        cache.setListObject(key, index, value);
    }

    public String[] getList(String key) {
        key = GlobalQingSessionImpl.getKey(key);
        return cache.getList(key);
    }

    public String[] getList(String key, int index, int length) {
        key = GlobalQingSessionImpl.getKey(key);
        return cache.getList(key, index, length);
    }

    public String getListObject(String key, int index) {
        key = GlobalQingSessionImpl.getKey(key);
        return cache.getListObject(key, index);
    }

    public void removeListObject(String key, int index) {
        key = GlobalQingSessionImpl.getKey(key);
        cache.removeListObject(key, index);
    }

    public void removeListObjects(String key, int index, int length) {
        key = GlobalQingSessionImpl.getKey(key);
        cache.removeListObjects(key, index, length);
    }

    public int getListLength(String key) {
        key = GlobalQingSessionImpl.getKey(key);
        return cache.getListLength(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> popList(String key) {
        key = GlobalQingSessionImpl.getKey(key);
        ILock redisListKeyLock = LockFactory.createLock((String)key);
        try {
            redisListKeyLock.lock();
            String[] list = cache.getList(key);
            if (list != null && list.length > 0) {
                cache.removeListObjects(key, 0, list.length);
                List<String> list2 = Arrays.asList(list);
                return list2;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LogUtil.error((String)"redis popList error", (Throwable)e);
        }
        catch (Exception e) {
            LogUtil.error((String)"redis popList error", (Throwable)e);
        }
        finally {
            redisListKeyLock.unlock();
        }
        return Collections.emptyList();
    }

    public long incrBy(String key, int count) {
        key = GlobalQingSessionImpl.getKey(key);
        return cache.incrBy(key, count);
    }

    public void addToSet(String key, String[] values) {
        key = GlobalQingSessionImpl.getKey(key);
        cache.addToSet(key, values);
    }

    public void addToSet(String key, String[] values, int timeout, TimeUnit timeUnit) {
        key = GlobalQingSessionImpl.getKey(key);
        cache.addToSet(key, values, timeout, timeUnit);
    }

    public String[] getSetValues(String key) {
        key = GlobalQingSessionImpl.getKey(key);
        return cache.getSetValues(key);
    }

    public void removeSetValue(String key, String[] valuesToRemove) {
        if (null == valuesToRemove || valuesToRemove.length == 0) {
            return;
        }
        key = GlobalQingSessionImpl.getKey(key);
        cache.removeSetValues(key, valuesToRemove);
    }

    public List<String> hKeys(String key) {
        key = GlobalQingSessionImpl.getKey(key);
        return cache.getKeys(key);
    }
}

