/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.qingshared.common.session;

import com.kingdee.bos.qing.common.session.AbstractQingSession;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;

public class QingSessionImpl
extends AbstractQingSession {
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("qing");

    public QingSessionImpl(String sessionId) {
        super(sessionId);
    }

    private int getDefaultTimeout() {
        String s = System.getProperty("redis.defaulttimeout");
        if (s != null) {
            try {
                return Integer.parseInt(s.trim()) + 1800;
            }
            catch (Exception var3) {
                LogUtil.error((String)("redis.defaulttimeout is not legal integer: " + s));
            }
        }
        return 5400;
    }

    public void set(String key, String value) {
        cache.put(this.getKey(), key, value, this.getDefaultTimeout(), TimeUnit.SECONDS);
    }

    public String get(String key) {
        return (String)cache.get(this.getKey(), key);
    }

    public void remove(String key) {
        cache.remove(this.getKey(), key);
    }
}

