/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.qingshared.common.systemvarloader;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.systemvar.SystemVarValue;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class BizOrgUnitIDValue
extends SystemVarValue {
    private volatile Set<Long> orgUnits;

    public BizOrgUnitIDValue(Object value) {
        super(value);
    }

    public Object getValue(QingContext qingContext) {
        this.loadOrgUnits(qingContext);
        return this.orgUnits;
    }

    public String getStringValue(QingContext qingContext) {
        this.loadOrgUnits(qingContext);
        StringBuilder stringBuilder = new StringBuilder();
        if (this.orgUnits != null) {
            boolean isFirst = true;
            for (Long value : this.orgUnits) {
                if (isFirst) {
                    stringBuilder.append(value);
                    isFirst = false;
                    continue;
                }
                stringBuilder.append("','").append(value);
            }
        }
        return stringBuilder.length() > 0 ? stringBuilder.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadOrgUnits(QingContext qingContext) {
        if (null != this.orgUnits) {
            return;
        }
        BizOrgUnitIDValue bizOrgUnitIDValue = this;
        synchronized (bizOrgUnitIDValue) {
            if (null != this.orgUnits) {
                return;
            }
            this.orgUnits = this.getOrgUnits(qingContext);
        }
    }

    private Set<Long> getOrgUnits(QingContext qingContext) {
        Long userId = (Long)super.getValue(qingContext);
        List userDptIds = UserServiceHelper.getOrgsUserJoin((long)userId);
        List usrPermOrgs = PermissionServiceHelper.getUserOrgs((long)userId);
        LogUtil.info((String)("current user perm orgs:" + usrPermOrgs));
        Set<Long> orgUnits = this.mergeOrgIds(userDptIds, usrPermOrgs);
        return orgUnits;
    }

    private Set<Long> mergeOrgIds(List<Long> userDptIds, List<Long> usrPermOrgs) {
        HashSet<Long> allOrgBizUnitIds = new HashSet<Long>();
        if (null != userDptIds) {
            allOrgBizUnitIds.addAll(userDptIds);
        }
        if (null != usrPermOrgs) {
            allOrgBizUnitIds.addAll(usrPermOrgs);
        }
        return allOrgBizUnitIds;
    }
}

