/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.qingshared.common.systemvarloader;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.systemvar.SystemVarValue;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.ThreadPoolManage;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.thread.ManagedThreadFeature;

public class CurrentUserNameValue
extends SystemVarValue {
    private volatile String currentUserName;

    public CurrentUserNameValue(Object value) {
        super(value);
    }

    public Object getValue(QingContext qingContext) {
        this.loadUserName(qingContext);
        return this.currentUserName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadUserName(QingContext qingContext) {
        if (null != this.currentUserName) {
            return;
        }
        CurrentUserNameValue currentUserNameValue = this;
        synchronized (currentUserNameValue) {
            block9: {
                if (null != this.currentUserName) {
                    return;
                }
                Long userId = (Long)super.getValue(qingContext);
                FutureUserNameTask futureUserNameTask = new FutureUserNameTask(userId);
                if (ManagedThreadFeature.isManaged()) {
                    this.currentUserName = futureUserNameTask.call();
                } else {
                    Future userNameFuture = ThreadPoolManage.excuteThreadWithContext((ThreadPoolManage.QingThreadPoolName)ThreadPoolManage.QingThreadPoolName.QING_SHORT_TIME_TASK_HANDLER, (Callable)futureUserNameTask, (QingContext)qingContext);
                    try {
                        this.currentUserName = (String)userNameFuture.get();
                    }
                    catch (Exception e) {
                        if (!LogUtil.isDebugEnabled()) break block9;
                        LogUtil.debug((String)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    public String getStringValue(QingContext qingContext) {
        Object value = this.getValue(qingContext);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    private static class FutureUserNameTask
    implements Callable<String> {
        private long userId;

        public FutureUserNameTask(long userId) {
            this.userId = userId;
        }

        @Override
        public String call() {
            Map userInfo = UserServiceHelper.getUserInfoByID((long)this.userId);
            if (userInfo != null) {
                return (String)userInfo.get("name");
            }
            return null;
        }
    }
}

