/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dfs.common.cmd;

import com.kingdee.bos.qing.dfs.common.cmd.AbstractExecuteCommand;
import com.kingdee.bos.qing.dfs.common.dfslock.QingInterProcessMutex;
import com.kingdee.bos.qing.dfs.common.util.CloseUtil;
import com.kingdee.bos.qing.dfs.common.util.LogUtil;
import com.kingdee.bos.qing.dfs.common.util.NetUtil;
import com.kingdee.bos.qing.dfs.common.util.ZKClientUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;

public class LocalExecuteCommand
extends AbstractExecuteCommand {
    @Override
    public int getLocalDiskUsage(String path) {
        File file = new File(path);
        if (file.exists()) {
            return (int)(file.getFreeSpace() / 1024L / 1024L);
        }
        return -1;
    }

    @Override
    public int getTotalSpace(String path) {
        File file = new File(path);
        if (file.exists()) {
            return (int)(file.getTotalSpace() / 1024L / 1024L);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public String execute(String cmd, boolean readResult) {
        String value;
        QingInterProcessMutex lock;
        Process process;
        block20: {
            if (cmd == null || "".equals(cmd.trim())) {
                LogUtil.info("not found command to execute");
                return null;
            }
            process = null;
            CuratorFramework client = ZKClientUtil.getClient();
            lock = new QingInterProcessMutex(client, NetUtil.getIp() + "execute");
            lock.acquire();
            process = Runtime.getRuntime().exec(cmd);
            value = null;
            if (readResult) {
                value = this.readAsString(process.getInputStream(), DEFAULTCHART);
            } else {
                new Thread(new ConsumeInputStream(cmd, process.getInputStream())).start();
            }
            new Thread(new ConsumeInputStream(cmd, process.getErrorStream())).start();
            process.waitFor(3L, TimeUnit.MINUTES);
            LogUtil.info("execute command: " + cmd + "\noutput: \n" + value);
            if (process.exitValue() == 0) break block20;
            LogUtil.error("ExitCode = " + process.exitValue() + ",Command execute failed. [" + cmd + "]");
            String string = null;
            try {
                lock.release();
            }
            catch (Exception e) {
                LogUtil.error("release lock error: " + e.getMessage(), e);
            }
            if (process != null) {
                process.destroy();
                CloseUtil.close(process.getInputStream(), process.getOutputStream(), process.getErrorStream());
                process = null;
            }
            return string;
        }
        LogUtil.info(value);
        String string = value;
        try {
            lock.release();
        }
        catch (Exception e) {
            LogUtil.error("release lock error: " + e.getMessage(), e);
        }
        if (process != null) {
            process.destroy();
            CloseUtil.close(process.getInputStream(), process.getOutputStream(), process.getErrorStream());
            process = null;
        }
        return string;
        catch (Throwable e) {
            String string2;
            try {
                LogUtil.error("execute command error: " + e.getMessage(), e);
                string2 = null;
            }
            catch (Throwable throwable) {
                try {
                    lock.release();
                }
                catch (Exception e2) {
                    LogUtil.error("release lock error: " + e2.getMessage(), e2);
                }
                if (process != null) {
                    process.destroy();
                    CloseUtil.close(process.getInputStream(), process.getOutputStream(), process.getErrorStream());
                    process = null;
                }
                throw throwable;
            }
            try {
                lock.release();
            }
            catch (Exception e3) {
                LogUtil.error("release lock error: " + e3.getMessage(), e3);
            }
            if (process != null) {
                process.destroy();
                CloseUtil.close(process.getInputStream(), process.getOutputStream(), process.getErrorStream());
                process = null;
            }
            return string2;
        }
    }

    private static class ConsumeInputStream
    implements Runnable {
        private String cmd;
        private InputStream inputStream;

        public ConsumeInputStream(String cmd, InputStream inputStream) {
            this.cmd = cmd;
            this.inputStream = inputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.inputStream != null) {
                BufferedReader bufferReader = new BufferedReader(new InputStreamReader(this.inputStream));
                try {
                    StringBuilder buffer = new StringBuilder();
                    buffer.append("execute command: ").append(this.cmd).append("\n");
                    String line = null;
                    while ((line = bufferReader.readLine()) != null) {
                        buffer.append(line);
                        buffer.append("\n");
                    }
                    LogUtil.info(buffer.toString());
                }
                catch (IOException iOException) {
                    CloseUtil.close(bufferReader, this.inputStream);
                }
                catch (Throwable throwable) {
                    CloseUtil.close(bufferReader, this.inputStream);
                    throw throwable;
                }
                CloseUtil.close(bufferReader, this.inputStream);
            }
        }
    }
}

