/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dfs.common.db;

import com.alibaba.druid.pool.DruidDataSource;
import com.kingdee.bos.qing.dfs.common.util.EnvUtil;
import com.kingdee.bos.qing.dfs.common.util.SystemPropertyUtil;
import java.sql.Connection;
import java.sql.SQLException;

public class DBUtil {
    private static DruidDataSource _dataSource;

    public static Connection getConnection() throws SQLException {
        return _dataSource.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        EnvUtil.init();
        Class<DBUtil> clazz = DBUtil.class;
        synchronized (DBUtil.class) {
            _dataSource = new DruidDataSource();
            String dbUrl = System.getenv("QING_JDBC_URL");
            String dbUserName = System.getenv("QING_JDBC_USERNAME");
            String dbPassword = System.getenv("QING_JDBC_PASSWORD");
            if (dbUrl == null) {
                dbUrl = SystemPropertyUtil.getString("qing.jdbc.url");
                dbUserName = SystemPropertyUtil.getString("qing.jdbc.username");
                dbPassword = SystemPropertyUtil.getString("qing.jdbc.password");
            }
            _dataSource.setUrl(dbUrl);
            _dataSource.setUsername(dbUserName);
            _dataSource.setPassword(dbPassword);
            _dataSource.setInitialSize(SystemPropertyUtil.getInt("qing.jdbc.initialSize", 2 * Runtime.getRuntime().availableProcessors()));
            _dataSource.setMaxActive(SystemPropertyUtil.getInt("qing.jdbc.maxActive", 20 * Runtime.getRuntime().availableProcessors()));
            _dataSource.setMinIdle(SystemPropertyUtil.getInt("qing.jdbc.minIdle", 2 * Runtime.getRuntime().availableProcessors()));
            _dataSource.setMaxWait(SystemPropertyUtil.getLong("qing.jdbc.maxWait", 30000L));
            _dataSource.setMinEvictableIdleTimeMillis(SystemPropertyUtil.getLong("qing.jdbc.minEvictableIdleTimeMillis", 600000L));
            _dataSource.setMaxEvictableIdleTimeMillis(SystemPropertyUtil.getLong("qing.jdbc.maxEvictableIdleTimeMillis", 900000L));
            _dataSource.setTimeBetweenEvictionRunsMillis(SystemPropertyUtil.getLong("qing.jdbc.timeBetweenEvictionRunsMillis", 2000L));
            _dataSource.setValidationQuery(SystemPropertyUtil.getString("qing.jdbc.validationQuery", "select 1"));
            _dataSource.setTestWhileIdle(SystemPropertyUtil.getBoolean("qing.jdbc.testWhileIdle", true));
            _dataSource.setKeepAlive(SystemPropertyUtil.getBoolean("qing.jdbc.keepAlive", true));
            _dataSource.setPhyTimeoutMillis(SystemPropertyUtil.getLong("qing.jdbc.phyTimeoutMillis", 1200000L));
            _dataSource.setRemoveAbandoned(SystemPropertyUtil.getBoolean("qing.jdbc.removeAbandoned", false));
            _dataSource.setRemoveAbandonedTimeout(SystemPropertyUtil.getInt("qing.jdbc.removeAbandonedTimeout", 1800));
            _dataSource.setLogAbandoned(SystemPropertyUtil.getBoolean("qing.jdbc.logAbandoned", false));
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

