/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dfs.common.db.impl;

import com.kingdee.bos.qing.dfs.common.db.IDBExcuter;
import com.kingdee.bos.qing.dfs.common.db.ParameterSetter;
import com.kingdee.bos.qing.dfs.common.db.ResultHandler;
import com.kingdee.bos.qing.dfs.common.db.impl.TXManageImpl;
import com.kingdee.bos.qing.dfs.common.util.CloseUtil;
import com.kingdee.bos.qing.dfs.common.util.LogUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

public class DBExcuterImpl
implements IDBExcuter {
    private TXManageImpl tx;

    public DBExcuterImpl(TXManageImpl tx) {
        this.tx = tx;
    }

    @Override
    public String genStringId(String tableName) {
        return UUID.randomUUID().toString();
    }

    @Override
    public String[] genStringId(String tableName, int size) {
        String[] ids = new String[size];
        for (int index = 0; index < size; ++index) {
            ids[index] = this.genStringId(tableName);
        }
        return ids;
    }

    private void setParams(PreparedStatement stmt, Object[] params) throws SQLException {
        if (params == null || params.length == 0) {
            return;
        }
        for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            if (param != null) {
                ParameterSetter.set(stmt, param, i + 1);
                continue;
            }
            int sqlType = 12;
            stmt.setNull(i + 1, sqlType);
        }
    }

    private void execute(Connection conn, String sql, Object[] params) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(sql);
            this.setParams(ps, params);
            ps.execute();
        }
        catch (SQLException e) {
            if (LogUtil.isDebugEnabled()) {
                LogUtil.debug("\u6267\u884csql\u5931\u8d25\u3002" + e.getMessage());
            }
            throw e;
        }
        finally {
            CloseUtil.close(ps);
        }
    }

    @Override
    public void execute(String sql, Object[] params) throws SQLException {
        Connection conn = this.tx.getTXConn();
        this.execute(conn, sql, params);
    }

    @Override
    public void executeBatch(String sql, List<Object[]> params) throws SQLException {
        Connection conn = this.tx.getTXConn();
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(sql);
            for (Object[] param : params) {
                this.setParams(ps, param);
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            if (LogUtil.isDebugEnabled()) {
                LogUtil.debug("\u6267\u884csql\u5931\u8d25\u3002" + e.getMessage());
            }
            throw e;
        }
        finally {
            CloseUtil.close(ps);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T query(String sql, Object[] params, ResultHandler<T> resultSetHandler) throws SQLException {
        T t;
        if (LogUtil.isDebugEnabled()) {
            LogUtil.debug("\u6267\u884csql:" + sql + "\t params:" + Arrays.toString(params));
        }
        Connection conn = this.tx.createConn();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(sql);
            this.setParams(ps, params);
            rs = ps.executeQuery();
            t = resultSetHandler.handle(rs);
        }
        catch (SQLException e) {
            try {
                if (LogUtil.isDebugEnabled()) {
                    LogUtil.debug("\u6267\u884csql\u5931\u8d25:" + sql + e.getMessage());
                }
                throw e;
                catch (Exception e2) {
                    if (LogUtil.isDebugEnabled()) {
                        LogUtil.debug("\u6267\u884csql\u5931\u8d25:" + sql + e2.getMessage());
                    }
                    throw new SQLException("faile to handle resultSet.", e2);
                }
            }
            catch (Throwable throwable) {
                CloseUtil.close(ps);
                CloseUtil.close(rs);
                CloseUtil.close(conn);
                throw throwable;
            }
        }
        CloseUtil.close(ps);
        CloseUtil.close(rs);
        CloseUtil.close(conn);
        return t;
    }

    @Override
    public Object createSqlParameterBytes(byte[] buf, int offset, int length) {
        byte[] subBlock = new byte[length];
        System.arraycopy(buf, offset, subBlock, 0, length);
        return subBlock;
    }

    @Override
    public void close() {
    }

    @Override
    public void executeBatchInsert(String sql, List<List<Object>> paramsList, int maxBatchInsertNumbers) throws SQLException {
        if (maxBatchInsertNumbers < 1) {
            maxBatchInsertNumbers = 1000;
        }
        try {
            ArrayList<Object[]> executeParamList = new ArrayList<Object[]>(maxBatchInsertNumbers);
            int len = paramsList.size();
            for (int i = 0; i < len; ++i) {
                executeParamList.add(paramsList.get(i).toArray());
                if (i % maxBatchInsertNumbers != 0) continue;
                this.executeBatch(sql, executeParamList);
                executeParamList.clear();
            }
            if (paramsList.size() % maxBatchInsertNumbers != 0) {
                this.executeBatch(sql, executeParamList);
            }
        }
        catch (SQLException e) {
            LogUtil.error("\u6570\u636e\u5e93\u6267\u884c\u5931\u8d25!sql:" + sql + "\t params:" + paramsList.toString());
            throw e;
        }
    }
}

