/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dfs.common.db.impl;

import com.kingdee.bos.qing.dfs.common.db.DBUtil;
import com.kingdee.bos.qing.dfs.common.db.ITransactionManagement;
import com.kingdee.bos.qing.dfs.common.util.CloseUtil;
import com.kingdee.bos.qing.dfs.common.util.LogUtil;
import java.sql.Connection;
import java.sql.SQLException;

public class TXManageImpl
implements ITransactionManagement {
    private Connection _connection = null;
    private boolean _shouldCommite = true;

    @Override
    public void beginRequired() throws SQLException {
        if (this._connection == null) {
            try {
                this._connection = this.createConn();
                this._connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                LogUtil.debug("faile to init connection.", e);
                if (this._connection != null) {
                    this._connection.close();
                }
                this._connection = null;
                throw e;
            }
        }
    }

    Connection createConn() throws SQLException {
        return DBUtil.getConnection();
    }

    Connection getTXConn() throws SQLException {
        if (this._connection == null) {
            this._connection = this.createConn();
        }
        return this._connection;
    }

    @Override
    public void markRollback() {
        this._shouldCommite = false;
        if (this._connection != null) {
            try {
                this._connection.rollback();
            }
            catch (SQLException e) {
                LogUtil.debug("rollback tx failed.", e);
            }
        }
    }

    @Override
    public void end() {
        if (this._shouldCommite && this._connection != null) {
            try {
                this._connection.commit();
                this._connection.setAutoCommit(true);
            }
            catch (SQLException e) {
                LogUtil.debug("commit tx failed.", e);
            }
        }
        CloseUtil.close(this._connection);
        this._connection = null;
    }
}

