/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dfs.common.filemanager.dao;

import com.kingdee.bos.qing.dfs.common.db.IDBExcuter;
import com.kingdee.bos.qing.dfs.common.db.ResultHandler;
import com.kingdee.bos.qing.dfs.common.exception.QingProgramException;
import com.kingdee.bos.qing.dfs.common.filemanager.IDFSFileHandler;
import com.kingdee.bos.qing.dfs.common.filemanager.dao.DFSFileSQLConstants;
import com.kingdee.bos.qing.dfs.common.filemanager.model.DFSFilePO;
import com.kingdee.bos.qing.dfs.common.filemanager.model.StoragedStatus;
import com.kingdee.bos.qing.dfs.common.util.LogUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DFSFileDao {
    private IDBExcuter _dbExcuter;
    private static final int PAGE_SIZE = 1000;

    public DFSFileDao(IDBExcuter dbexcuter) {
        this._dbExcuter = dbexcuter;
    }

    public Date visitFile(String fileName) throws SQLException {
        Date date = new Date();
        this._dbExcuter.execute("UPDATE t_qing_dfs_file SET FLASTVISITTIME=? WHERE FFILENAME=?", new Object[]{date, fileName});
        return date;
    }

    public DFSFilePO findDFSFile(String fileName) throws SQLException {
        if (fileName == null) {
            return null;
        }
        DFSFilePO po = this.findDFSFileByFileName(fileName);
        return po;
    }

    private DFSFilePO findDFSFileByFileName(final String fileName) throws SQLException {
        return this._dbExcuter.query("SELECT FFILETYPEINDEX, FGROUPNAME, FBUCKETNAME, FRELATIVEFILEPATH, FCREATETIME, FLASTVISITTIME, FSIZE, FLEVEL0, FLEVEL1, FLEVEL2, FLEVEL3, FISTEMP, FISDELETE FROM t_qing_dfs_file WHERE FFILENAME=?", new Object[]{fileName}, new ResultHandler<DFSFilePO>(){

            @Override
            public DFSFilePO handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    DFSFilePO dfsFilePO = new DFSFilePO();
                    dfsFilePO.setFileName(fileName);
                    dfsFilePO.setFileTypeIndex(rs.getInt("FFILETYPEINDEX"));
                    dfsFilePO.setGroupName(rs.getString("FGROUPNAME"));
                    dfsFilePO.setBucketName(rs.getString("FBUCKETNAME"));
                    dfsFilePO.setRelativeFilePath(rs.getString("FRELATIVEFILEPATH"));
                    dfsFilePO.setCreateTime(rs.getTimestamp("FCREATETIME"));
                    dfsFilePO.setLastVisitTime(rs.getTimestamp("FLASTVISITTIME"));
                    dfsFilePO.setSize(rs.getLong("FSIZE"));
                    try {
                        dfsFilePO.setLevel0(StoragedStatus.fromPersistance(rs.getString("FLEVEL0")));
                        dfsFilePO.setLevel1(StoragedStatus.fromPersistance(rs.getString("FLEVEL1")));
                        dfsFilePO.setLevel2(StoragedStatus.fromPersistance(rs.getString("FLEVEL2")));
                        dfsFilePO.setLevel3(StoragedStatus.fromPersistance(rs.getString("FLEVEL3")));
                    }
                    catch (QingProgramException e) {
                        LogUtil.error(e.getMessage(), e);
                    }
                    boolean temp = !"0".equals(rs.getString("FISTEMP"));
                    boolean delete = !"0".equals(rs.getString("FISDELETE"));
                    dfsFilePO.setTemp(temp);
                    dfsFilePO.setDelete(delete);
                    return dfsFilePO;
                }
                return null;
            }
        });
    }

    public void createFile(DFSFilePO filePO) throws SQLException {
        String fileName = filePO.getFileName();
        boolean isTemp = filePO.isTemp();
        this._dbExcuter.execute("INSERT INTO t_qing_dfs_file(FFILENAME, FFILETYPEINDEX, FGROUPNAME, FBUCKETNAME, FRELATIVEFILEPATH, FCREATETIME, FLASTVISITTIME, FSIZE, FLEVEL0, FLEVEL1, FLEVEL2, FLEVEL3, FISTEMP) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?)", new Object[]{fileName, filePO.getFileTypeIndex(), filePO.getGroupName(), filePO.getBucketName(), filePO.getRelativeFilePath(), filePO.getCreateTime(), filePO.getLastVisitTime(), filePO.getSize(), filePO.getLevel0().toPersistance(), filePO.getLevel1().toPersistance(), filePO.getLevel2().toPersistance(), filePO.getLevel3().toPersistance(), isTemp ? "1" : "0"});
    }

    public void updateLevelByFileName(int level, StoragedStatus storagedStatus, String fileName) throws SQLException {
        this._dbExcuter.execute(DFSFileSQLConstants.getUpdateSqlByLevelAndStatus(level, storagedStatus), new Object[]{fileName});
    }

    public void updateLevelByFileNames(int level, StoragedStatus storagedStatus, List<String> fileNames) throws SQLException {
        ArrayList<Object[]> params = new ArrayList<Object[]>(fileNames.size());
        for (String fileName : fileNames) {
            params.add(new Object[]{fileName});
        }
        this._dbExcuter.executeBatch(DFSFileSQLConstants.getUpdateSqlByLevelAndStatus(level, storagedStatus), params);
    }

    public void deleteByFileName(String fileName) throws SQLException {
        this._dbExcuter.execute("DELETE FROM t_qing_dfs_file WHERE FFILENAME = ?", new Object[]{fileName});
    }

    public void deleteByFileNamesInDB(List<String> fileNames) throws SQLException {
        ArrayList<Object[]> params = new ArrayList<Object[]>(fileNames.size());
        for (String fileName : fileNames) {
            params.add(new Object[]{fileName});
        }
        this._dbExcuter.executeBatch("DELETE FROM t_qing_dfs_file WHERE FFILENAME = ?", params);
    }

    private StoragedStatus parseStoragedStatus(String value) {
        try {
            return StoragedStatus.fromPersistance(value);
        }
        catch (QingProgramException e) {
            LogUtil.error(e.getMessage(), e);
            return null;
        }
    }

    public void findAndHandleUnsyncFilesByGroupAndLevel(final String groupName, Integer level, final IDFSFileHandler handler) throws SQLException {
        String sql = DFSFileSQLConstants.getFindUnsyncGroupFilesSqlByLevel(level);
        this._dbExcuter.query(sql, new Object[]{groupName}, new ResultHandler<Object>(){

            @Override
            public Object handle(ResultSet rs) throws SQLException {
                ArrayList<DFSFilePO> dfsFilePOList = new ArrayList<DFSFilePO>(1000);
                while (rs.next()) {
                    DFSFilePO dfsFilePO = new DFSFilePO();
                    dfsFilePO.setFileName(rs.getString("FFILENAME"));
                    dfsFilePO.setFileTypeIndex(rs.getInt("FFILETYPEINDEX"));
                    dfsFilePO.setGroupName(groupName);
                    dfsFilePO.setBucketName(rs.getString("FBUCKETNAME"));
                    dfsFilePO.setRelativeFilePath(rs.getString("FRELATIVEFILEPATH"));
                    dfsFilePO.setCreateTime(rs.getTimestamp("FCREATETIME"));
                    dfsFilePO.setLastVisitTime(rs.getTimestamp("FLASTVISITTIME"));
                    dfsFilePO.setSize(rs.getLong("FSIZE"));
                    dfsFilePO.setLevel0(DFSFileDao.this.parseStoragedStatus(rs.getString("FLEVEL0")));
                    dfsFilePO.setLevel1(DFSFileDao.this.parseStoragedStatus(rs.getString("FLEVEL1")));
                    dfsFilePO.setLevel2(DFSFileDao.this.parseStoragedStatus(rs.getString("FLEVEL2")));
                    dfsFilePO.setLevel3(DFSFileDao.this.parseStoragedStatus(rs.getString("FLEVEL3")));
                    boolean temp = !"0".equals(rs.getString("FISTEMP"));
                    boolean delete = !"0".equals(rs.getString("FISDELETE"));
                    dfsFilePO.setTemp(temp);
                    dfsFilePO.setDelete(delete);
                    dfsFilePOList.add(dfsFilePO);
                    if (dfsFilePOList.size() != 1000) continue;
                    handler.handle(dfsFilePOList);
                    dfsFilePOList.clear();
                }
                if (!dfsFilePOList.isEmpty()) {
                    handler.handle(dfsFilePOList);
                }
                return null;
            }
        });
    }

    public void findAndHandleTimeoutTempFilesByGroupAndLevel(final String groupName, Integer level, final IDFSFileHandler handler) throws SQLException {
        String sql = DFSFileSQLConstants.getFindTimeoutTempGroupFilesSqlByLevel(level);
        this._dbExcuter.query(sql, new Object[]{groupName}, new ResultHandler<Object>(){

            @Override
            public Object handle(ResultSet rs) throws SQLException {
                ArrayList<DFSFilePO> dfsFilePOList = new ArrayList<DFSFilePO>(1000);
                while (rs.next()) {
                    DFSFilePO dfsFilePO = new DFSFilePO();
                    dfsFilePO.setFileName(rs.getString("FFILENAME"));
                    dfsFilePO.setFileTypeIndex(rs.getInt("FFILETYPEINDEX"));
                    dfsFilePO.setGroupName(groupName);
                    dfsFilePO.setBucketName(rs.getString("FBUCKETNAME"));
                    dfsFilePO.setRelativeFilePath(rs.getString("FRELATIVEFILEPATH"));
                    dfsFilePO.setCreateTime(rs.getTimestamp("FCREATETIME"));
                    dfsFilePO.setLastVisitTime(rs.getTimestamp("FLASTVISITTIME"));
                    dfsFilePO.setSize(rs.getLong("FSIZE"));
                    dfsFilePO.setLevel0(DFSFileDao.this.parseStoragedStatus(rs.getString("FLEVEL0")));
                    dfsFilePO.setLevel1(DFSFileDao.this.parseStoragedStatus(rs.getString("FLEVEL1")));
                    dfsFilePO.setLevel2(DFSFileDao.this.parseStoragedStatus(rs.getString("FLEVEL2")));
                    dfsFilePO.setLevel3(DFSFileDao.this.parseStoragedStatus(rs.getString("FLEVEL3")));
                    boolean delete = !"0".equals(rs.getString("FISDELETE"));
                    dfsFilePO.setTemp(true);
                    dfsFilePO.setDelete(delete);
                    dfsFilePOList.add(dfsFilePO);
                    if (dfsFilePOList.size() != 1000) continue;
                    handler.handle(dfsFilePOList);
                    dfsFilePOList.clear();
                }
                if (!dfsFilePOList.isEmpty()) {
                    handler.handle(dfsFilePOList);
                }
                return null;
            }
        });
    }

    public void findAndHandleAllLevelDeletedFilesByGroup(final String groupName, final IDFSFileHandler handler) throws SQLException {
        this._dbExcuter.query(DFSFileSQLConstants.FIND_ALL_LEVEL_DELETED_FILES_BY_GROUP, new Object[]{groupName}, new ResultHandler<Object>(){

            @Override
            public Object handle(ResultSet rs) throws SQLException {
                ArrayList<DFSFilePO> dfsFilePOList = new ArrayList<DFSFilePO>(1000);
                while (rs.next()) {
                    DFSFilePO dfsFilePO = new DFSFilePO();
                    dfsFilePO.setFileName(rs.getString("FFILENAME"));
                    dfsFilePO.setFileTypeIndex(rs.getInt("FFILETYPEINDEX"));
                    dfsFilePO.setGroupName(groupName);
                    dfsFilePO.setBucketName(rs.getString("FBUCKETNAME"));
                    dfsFilePO.setRelativeFilePath(rs.getString("FRELATIVEFILEPATH"));
                    dfsFilePOList.add(dfsFilePO);
                    if (dfsFilePOList.size() != 1000) continue;
                    handler.handle(dfsFilePOList);
                    dfsFilePOList.clear();
                }
                if (!dfsFilePOList.isEmpty()) {
                    handler.handle(dfsFilePOList);
                }
                return null;
            }
        });
    }
}

