/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dfs.common.filemanager.dao;

import com.kingdee.bos.qing.dfs.common.filemanager.model.StoragedStatus;

public class DFSFileSQLConstants {
    public static final String VISIT_DFS_FILE = "UPDATE t_qing_dfs_file SET FLASTVISITTIME=? WHERE FFILENAME=?";
    public static final String FIND_DFS_FILE = "SELECT FFILETYPEINDEX, FGROUPNAME, FBUCKETNAME, FRELATIVEFILEPATH, FCREATETIME, FLASTVISITTIME, FSIZE, FLEVEL0, FLEVEL1, FLEVEL2, FLEVEL3, FISTEMP, FISDELETE FROM t_qing_dfs_file WHERE FFILENAME=?";
    public static final String INSERT_DFS_FILE = "INSERT INTO t_qing_dfs_file(FFILENAME, FFILETYPEINDEX, FGROUPNAME, FBUCKETNAME, FRELATIVEFILEPATH, FCREATETIME, FLASTVISITTIME, FSIZE, FLEVEL0, FLEVEL1, FLEVEL2, FLEVEL3, FISTEMP) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?)";
    public static final String DELETE_BY_FILENAME = "DELETE FROM t_qing_dfs_file WHERE FFILENAME = ?";
    public static final String FIND_ALL_LEVEL_DELETED_FILES_BY_GROUP = "SELECT FFILENAME, FFILETYPEINDEX, FBUCKETNAME, FRELATIVEFILEPATH FROM t_qing_dfs_file WHERE FGROUPNAME=? AND FISDELETE = '1' AND FLEVEL0 <> " + StoragedStatus.STORAGED.getId() + " AND FLEVEL1 <> " + StoragedStatus.STORAGED.getId() + " AND FLEVEL2 <> " + StoragedStatus.STORAGED.getId() + " AND FLEVEL3 <> " + StoragedStatus.STORAGED.getId();

    private static String getLevelFieldNameByLevel(int level) {
        String fieldName;
        switch (level) {
            case 0: {
                fieldName = "FLEVEL0";
                break;
            }
            case 1: {
                fieldName = "FLEVEL1";
                break;
            }
            case 2: {
                fieldName = "FLEVEL2";
                break;
            }
            case 3: {
                fieldName = "FLEVEL3";
                break;
            }
            default: {
                throw new RuntimeException("unknown level");
            }
        }
        return fieldName;
    }

    public static final String getUpdateSqlByLevelAndStatus(int level, StoragedStatus status) {
        String levelField = DFSFileSQLConstants.getLevelFieldNameByLevel(level);
        String sql = "update t_qing_dfs_file set " + levelField + "= '" + StoragedStatus.STORAGED.getId() + "' where FFILENAME = ?";
        if (status == StoragedStatus.DELETED) {
            sql = "update t_qing_dfs_file set FISDELETE = '1', " + levelField + "= '" + StoragedStatus.DELETED.getId() + "' where FFILENAME = ?";
        }
        return sql;
    }

    public static final String getFindUnsyncGroupFilesSqlByLevel(int level) {
        String levelField = DFSFileSQLConstants.getLevelFieldNameByLevel(level);
        String sql = "SELECT FFILENAME, FFILETYPEINDEX, FBUCKETNAME, FRELATIVEFILEPATH, FCREATETIME, FLASTVISITTIME, FSIZE, FLEVEL0, FLEVEL1, FLEVEL2, FLEVEL3, FISTEMP, FISDELETE  FROM t_qing_dfs_file  WHERE FGROUPNAME=?  AND ( \t\t(" + levelField + "=" + StoragedStatus.DEFAULT.getId() + " AND FISDELETE='0'\t\t\t) \t\tor  \t\t(" + levelField + "=" + StoragedStatus.STORAGED.getId() + " AND FISDELETE = '1' \t\t)) ";
        return sql;
    }

    public static final String getFindTimeoutTempGroupFilesSqlByLevel(int level) {
        String levelField = DFSFileSQLConstants.getLevelFieldNameByLevel(level);
        String sql = "SELECT FFILENAME, FFILETYPEINDEX, FBUCKETNAME, FRELATIVEFILEPATH, FCREATETIME, FLASTVISITTIME, FSIZE, FLEVEL0, FLEVEL1, FLEVEL2, FLEVEL3, FISDELETE FROM t_qing_dfs_file WHERE FGROUPNAME=? AND FISTEMP = '1' AND " + levelField + "=" + StoragedStatus.STORAGED.getId() + " AND DATE_SUB(CURDATE(), INTERVAL 1 DAY) >= date(FLASTVISITTIME)";
        return sql;
    }
}

