/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dfs.common.filemanager.domain;

import com.kingdee.bos.qing.dfs.common.db.impl.DBExcuterImpl;
import com.kingdee.bos.qing.dfs.common.db.impl.TXManageImpl;
import com.kingdee.bos.qing.dfs.common.filemanager.IDFSFileHandler;
import com.kingdee.bos.qing.dfs.common.filemanager.dao.DFSFileDao;
import com.kingdee.bos.qing.dfs.common.filemanager.model.DFSFilePO;
import com.kingdee.bos.qing.dfs.common.filemanager.model.StoragedStatus;
import com.kingdee.bos.qing.dfs.common.util.LogUtil;
import com.kingdee.bos.qing.dfs.common.writingrecord.dao.WritingRecordDao;
import com.kingdee.bos.qing.dfs.common.writingrecord.dao.impl.WritingRecordImpl;
import java.sql.SQLException;
import java.util.List;

public class DFSFileDomain {
    private DBExcuterImpl excuter;
    private TXManageImpl tx = new TXManageImpl();
    private DFSFileDao dfsFileDao;
    private WritingRecordDao writingRecordDao;

    public DFSFileDomain() {
        this.excuter = new DBExcuterImpl(this.tx);
        this.dfsFileDao = new DFSFileDao(this.excuter);
        this.writingRecordDao = new WritingRecordImpl(this.excuter);
    }

    public DFSFilePO findDFSFile(String fileName) throws SQLException {
        return this.dfsFileDao.findDFSFile(fileName);
    }

    public void visitFile(String fileName) throws SQLException {
        try {
            this.tx.beginRequired();
            this.dfsFileDao.visitFile(fileName);
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
    }

    public void createFile(DFSFilePO filePO) throws SQLException {
        try {
            this.tx.beginRequired();
            this.writingRecordDao.deleteByFileName(filePO.getFileName());
            this.dfsFileDao.createFile(filePO);
        }
        catch (SQLException e) {
            this.tx.markRollback();
            LogUtil.error(e.getMessage(), e);
            throw e;
        }
        finally {
            this.tx.end();
        }
    }

    public void updateFileLevel(String fileName, StoragedStatus storagedStatus, Integer level) throws SQLException {
        try {
            this.tx.beginRequired();
            this.dfsFileDao.updateLevelByFileName(level, storagedStatus, fileName);
        }
        catch (SQLException e) {
            LogUtil.error(e.getMessage(), e);
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
    }

    public void updateFilesLevel(List<String> fileNames, StoragedStatus storagedStatus, Integer level) throws SQLException {
        try {
            this.tx.beginRequired();
            this.dfsFileDao.updateLevelByFileNames(level, storagedStatus, fileNames);
        }
        catch (SQLException e) {
            LogUtil.error(e.getMessage(), e);
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteByFileName(String fileName) {
        try {
            this.tx.beginRequired();
            this.dfsFileDao.deleteByFileName(fileName);
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            LogUtil.error(e.getMessage(), e);
            this.tx.markRollback();
            boolean bl = false;
            return bl;
        }
        finally {
            this.tx.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteByFileNamesInDB(List<String> fileNames) {
        try {
            this.tx.beginRequired();
            this.dfsFileDao.deleteByFileNamesInDB(fileNames);
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            LogUtil.error(e.getMessage(), e);
            this.tx.markRollback();
            boolean bl = false;
            return bl;
        }
        finally {
            this.tx.end();
        }
    }

    public void findAndHandleUnsyncFilesByGroupAndLevel(String groupName, Integer level, IDFSFileHandler handler) throws SQLException {
        this.dfsFileDao.findAndHandleUnsyncFilesByGroupAndLevel(groupName, level, handler);
    }

    public void findAndHandleTempFilesByGroupAndLevel(String groupName, Integer level, IDFSFileHandler handler) throws SQLException {
        this.dfsFileDao.findAndHandleTimeoutTempFilesByGroupAndLevel(groupName, level, handler);
    }

    public void findAndHandleAllLevelDeletedFilesByGroup(String groupName, IDFSFileHandler handler) throws SQLException {
        this.dfsFileDao.findAndHandleAllLevelDeletedFilesByGroup(groupName, handler);
    }
}

