/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dfs.common.listener;

import com.kingdee.bos.qing.dfs.common.model.AbstractBucketElement;
import com.kingdee.bos.qing.dfs.common.util.LogUtil;
import java.nio.charset.Charset;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.curator.framework.recipes.cache.TreeCacheListener;

public abstract class AbstractDFSNodeChangeListener
implements TreeCacheListener {
    public void childEvent(CuratorFramework client, TreeCacheEvent event) {
        TreeCacheEvent.Type type = event.getType();
        ChildData data = event.getData();
        byte[] bytes = null;
        if (LogUtil.isDebugEnabled()) {
            LogUtil.debug(type.toString());
        }
        if (data != null) {
            if (LogUtil.isDebugEnabled()) {
                LogUtil.debug(data.getPath());
            }
            if ((bytes = data.getData()) == null) {
                return;
            }
            if (LogUtil.isDebugEnabled()) {
                LogUtil.debug(new String(bytes, Charset.forName("utf-8")));
            }
        }
        switch (type) {
            case NODE_ADDED: 
            case NODE_REMOVED: 
            case NODE_UPDATED: {
                break;
            }
            case INITIALIZED: {
                this.initialized();
                return;
            }
            default: {
                return;
            }
        }
        AbstractBucketElement element = AbstractBucketElement.fromDataByte(bytes);
        if (element == null) {
            return;
        }
        switch (type) {
            case NODE_ADDED: 
            case NODE_UPDATED: {
                this.saveOrUpdateBucketElement(element);
                break;
            }
            case NODE_REMOVED: {
                this.removeBucketElement(element);
                break;
            }
        }
    }

    protected abstract void initialized();

    protected abstract void removeBucketElement(AbstractBucketElement var1);

    protected abstract void saveOrUpdateBucketElement(AbstractBucketElement var1);
}

