/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dfs.common.model;

import com.kingdee.bos.qing.dfs.common.model.AbstractBucketElement;
import com.kingdee.bos.qing.dfs.common.util.NetUtil;
import com.kingdee.bos.qing.dfs.common.util.ZKClientUtil;
import com.kingdee.bos.qing.dfs.common.xml.IXmlElement;

public class BucketGroupInfo
extends AbstractBucketElement {
    private String serverIp;
    private String serverUrl;
    private String serverFilePath;
    private String serverNFSFilePath;
    private String clientFilePath;
    private String mountOtherLevelPath;
    private String mountCommandPrefix;
    private String umountCommandPrefix;
    private transient boolean usable = true;

    public static BucketGroupInfo fromXML(IXmlElement element) {
        BucketGroupInfo bucketGroup = new BucketGroupInfo();
        bucketGroup.name = element.getAttribute("name");
        bucketGroup.level = Integer.parseInt(element.getAttribute("level"));
        bucketGroup.serverFilePath = element.getAttribute("serverFilePath");
        bucketGroup.serverNFSFilePath = element.getAttribute("serverNFSFilePath");
        bucketGroup.clientFilePath = element.getAttribute("clientFilePath");
        bucketGroup.mountOtherLevelPath = element.getAttribute("mountOtherLevelPath");
        bucketGroup.mountCommandPrefix = element.getAttribute("mountCommandPrefix");
        bucketGroup.umountCommandPrefix = element.getAttribute("umountCommandPrefix");
        return bucketGroup;
    }

    public String getServerIp() {
        return this.serverIp;
    }

    public void setServerIp(String serverIp) {
        this.serverIp = serverIp;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getServerFilePath() {
        return this.serverFilePath;
    }

    public void setServerFilePath(String serverFilePath) {
        this.serverFilePath = serverFilePath;
    }

    public String getServerNFSFilePath() {
        return this.serverNFSFilePath;
    }

    public void setServerNFSFilePath(String serverNFSFilePath) {
        this.serverNFSFilePath = serverNFSFilePath;
    }

    public String getClientFilePath() {
        return this.clientFilePath;
    }

    public void setClientFilePath(String clientFilePath) {
        this.clientFilePath = clientFilePath;
    }

    public String getMountOtherLevelPath() {
        return this.mountOtherLevelPath;
    }

    public void setMountOtherLevelPath(String mountOtherLevelPath) {
        this.mountOtherLevelPath = mountOtherLevelPath;
    }

    public boolean isUsable() {
        return this.usable;
    }

    public void setUsable(boolean usable) {
        this.usable = usable;
    }

    public String getMountCommand() {
        if (this.mountCommandPrefix != null && !"".equals(this.mountCommandPrefix)) {
            return this.mountCommandPrefix + " " + this.serverIp + ":" + this.serverNFSFilePath + " " + this.clientFilePath;
        }
        return "";
    }

    public String getUmountCommand() {
        if (this.umountCommandPrefix != null && !"".equals(this.umountCommandPrefix)) {
            return this.umountCommandPrefix + " " + this.clientFilePath;
        }
        return "";
    }

    public String getMountCommand(String path) {
        if (this.mountCommandPrefix != null && !"".equals(this.mountCommandPrefix)) {
            return this.mountCommandPrefix + " " + this.serverIp + ":" + this.serverNFSFilePath + " " + path;
        }
        return "";
    }

    public String getUmountCommand(String path) {
        if (this.umountCommandPrefix != null && !"".equals(this.umountCommandPrefix)) {
            return this.umountCommandPrefix + " " + path;
        }
        return "";
    }

    public String getInfoGroupPath() {
        return ZKClientUtil.getZKRootPath() + "/QingStorage" + "/" + "level" + this.level + "/" + this.name;
    }

    public String getInfoNodePath() {
        return ZKClientUtil.getZKRootPath() + "/QingStorage" + "/" + "level" + this.level + "/" + this.name + "/info";
    }

    public String getOtherLevelInfoNodePath(int otherLevel) {
        return ZKClientUtil.getZKRootPath() + "/QingStorage" + "/" + "level" + otherLevel + "/" + this.name + "/info";
    }

    public String getComputationNodePath() {
        return ZKClientUtil.getZKRootPath() + "/QingStorage" + "/" + "level" + this.level + "/" + this.name + "/computation";
    }

    public String getComputationProcessNodePath() {
        return this.getComputationNodePath() + "/" + NetUtil.getProcessID();
    }
}

