/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dfs.common.service;

import com.kingdee.bos.qing.dfs.common.cmd.LocalExecuteCommand;
import com.kingdee.bos.qing.dfs.common.model.BucketGroupInfo;
import com.kingdee.bos.qing.dfs.common.util.LogUtil;
import com.kingdee.bos.qing.dfs.common.util.NetUtil;
import com.kingdee.bos.qing.dfs.common.util.ZKClientUtil;
import java.io.File;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.zookeeper.CreateMode;

public class MountServie {
    private static boolean mntByProgram = true;

    public static void mount(BucketGroupInfo bucketGroupInfo) {
        if (!mntByProgram) {
            LogUtil.info("Not mount: " + bucketGroupInfo.toJson() + ", because of `QING_MNT_COMPLETE=false`");
            return;
        }
        CuratorFramework client = ZKClientUtil.getClient();
        LocalExecuteCommand command = new LocalExecuteCommand();
        File file = new File(bucketGroupInfo.getClientFilePath());
        if (MountServie.isMounted(bucketGroupInfo.getClientFilePath())) {
            command.execute(bucketGroupInfo.getUmountCommand(), false);
            LogUtil.info("file exists do umount: " + bucketGroupInfo.getUmountCommand());
        } else if (NetUtil.isOSLinux() && !file.exists()) {
            file.mkdirs();
        }
        command.execute(bucketGroupInfo.getMountCommand(), false);
        LogUtil.info("do mount: " + bucketGroupInfo.getMountCommand());
        if (MountServie.isMounted(bucketGroupInfo.getClientFilePath())) {
            try {
                if (client.checkExists().forPath(bucketGroupInfo.getComputationNodePath()) == null) {
                    client.create().creatingParentsIfNeeded().forPath(bucketGroupInfo.getComputationNodePath(), new byte[0]);
                }
            }
            catch (Throwable e) {
                LogUtil.warn("create computationNode failed. \nnode Path:" + bucketGroupInfo.getComputationNodePath() + "\nmessage:" + e.getMessage());
            }
            try {
                String computationProcessNodePath = bucketGroupInfo.getComputationProcessNodePath();
                if (client.checkExists().forPath(computationProcessNodePath) != null) {
                    client.delete().forPath(computationProcessNodePath);
                }
                ((ACLBackgroundPathAndBytesable)client.create().withMode(CreateMode.EPHEMERAL)).forPath(bucketGroupInfo.getComputationProcessNodePath());
                bucketGroupInfo.setUsable(true);
            }
            catch (Exception e) {
                LogUtil.error("setUsable false: failed to make bucketGroup used." + e.getMessage());
                if (LogUtil.isDebugEnabled()) {
                    LogUtil.error(e.getMessage(), e);
                }
                bucketGroupInfo.setUsable(false);
                LogUtil.error("setUsable false: unmount BucketGroup. group info:" + bucketGroupInfo.toJson());
                command.execute(bucketGroupInfo.getUmountCommand(), false);
            }
        } else {
            LogUtil.error("setUsable false: mount BucketGroup failed.group info :" + bucketGroupInfo.toJson());
            bucketGroupInfo.setUsable(false);
        }
    }

    public static void mount(BucketGroupInfo bucketGroupInfo, String mountPath) {
        if (!mntByProgram) {
            return;
        }
        LocalExecuteCommand command = new LocalExecuteCommand();
        File file = new File(mountPath);
        if (MountServie.isMounted(mountPath)) {
            command.execute(bucketGroupInfo.getUmountCommand(mountPath), false);
            LogUtil.info("file exists do umount specified path: " + bucketGroupInfo.getUmountCommand(mountPath));
        } else if (NetUtil.isOSLinux() && !file.exists()) {
            file.mkdirs();
        }
        command.execute(bucketGroupInfo.getMountCommand(mountPath), false);
        LogUtil.info("do mount specified path: " + bucketGroupInfo.getMountCommand(mountPath));
    }

    public static void umount(BucketGroupInfo bucketGroupInfo) {
        if (!mntByProgram) {
            return;
        }
        CuratorFramework client = ZKClientUtil.getClient();
        LocalExecuteCommand command = new LocalExecuteCommand();
        if (MountServie.isMounted(bucketGroupInfo.getClientFilePath())) {
            command.execute(bucketGroupInfo.getUmountCommand(), false);
            LogUtil.info("do umount: " + bucketGroupInfo.getUmountCommand());
        }
        if (!MountServie.isMounted(bucketGroupInfo.getClientFilePath())) {
            try {
                LogUtil.info("do umount success, delete computationProcessNodePath: " + bucketGroupInfo.getComputationProcessNodePath());
                client.delete().forPath(bucketGroupInfo.getComputationProcessNodePath());
            }
            catch (Exception e) {
                LogUtil.error("delete computationProcessNodePath failed", e);
            }
        }
    }

    public static void umount(BucketGroupInfo bucketGroupInfo, String mountPath) {
        if (!mntByProgram) {
            return;
        }
        LocalExecuteCommand command = new LocalExecuteCommand();
        if (MountServie.isMounted(mountPath)) {
            command.execute(bucketGroupInfo.getUmountCommand(mountPath), false);
            LogUtil.info("do umount specified path: " + bucketGroupInfo.getUmountCommand(mountPath));
        }
    }

    public static boolean isMounted(String mountPath) {
        File file = new File(mountPath);
        if (file.exists() && file.listFiles() != null && file.listFiles().length > 0) {
            LogUtil.info("path: " + mountPath + " is mounted, because file path not empty!");
            return true;
        }
        return false;
    }

    static {
        String mntComplete = System.getenv().get("QING_MNT_COMPLETE");
        if (mntComplete != null && mntByProgram) {
            mntByProgram = false;
        }
    }
}

