/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dfs.common.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;

public class JsonUtil {
    private static Gson gson = new Gson();

    public static String encodeToString(Object obj) {
        return gson.toJson(obj);
    }

    public static <T> T decodeFromString(String jsonString, Class<T> clz) {
        return (T)gson.fromJson(jsonString, clz);
    }

    public static String encodeToString(CustomJsonParser customParser, Object obj) {
        return customParser.getGson().toJson(obj);
    }

    public static <T> T decodeFromString(CustomJsonParser customParser, String jsonString, Class<T> clz) {
        return (T)customParser.getGson().fromJson(jsonString, clz);
    }

    public static abstract class AbstractJsonDecoder<T>
    implements JsonDeserializer<T> {
        private GsonBuilder _gsonBuilderWithCustomAdapter;

        public final void bindGsonBuilder(GsonBuilder gsonBuilder) {
            this._gsonBuilderWithCustomAdapter = gsonBuilder;
        }

        protected final <U extends T> T fromJson(Json json, Class<U> clz) {
            return (T)this._gsonBuilderWithCustomAdapter.create().fromJson((JsonElement)json._jsonObject, clz);
        }

        public final T deserialize(JsonElement jsonElement, Type typeT, JsonDeserializationContext ctx) throws JsonParseException {
            if (jsonElement.isJsonObject()) {
                JsonObject jo = jsonElement.getAsJsonObject();
                try {
                    return this.decode(new Json(jo));
                }
                catch (Exception ex) {
                    throw new JsonParseException((Throwable)ex);
                }
            }
            return null;
        }

        protected abstract T decode(Json var1);

        protected static class Json {
            private JsonObject _jsonObject;

            public Json(JsonObject jo) {
                this._jsonObject = jo;
            }

            public boolean hasAttr(String attrKey) {
                return this._jsonObject.has(attrKey);
            }

            public String getAttrValue(String attrKey) {
                return this._jsonObject.get(attrKey).getAsString();
            }
        }
    }

    public static class CustomJsonParser {
        private GsonBuilder _gsonBuilder = new GsonBuilder();
        private Gson _gson;

        public void addCustomDecoder(Class<?> clz, AbstractJsonDecoder<?> decoder) {
            this._gson = null;
            this._gsonBuilder.registerTypeAdapter(clz, decoder);
            decoder.bindGsonBuilder(this._gsonBuilder);
        }

        public Gson getGson() {
            if (this._gson == null) {
                this._gson = this._gsonBuilder.create();
            }
            return this._gson;
        }
    }
}

