/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dfs.common.util;

import java.io.PrintStream;
import org.apache.log4j.Logger;

public class LogUtil {
    private static ILogger _impl;

    public static boolean isDebugEnabled() {
        return LogUtil.getImpl().isDebugEnabled();
    }

    public static void debug(String message) {
        LogUtil.getImpl().debug(message);
    }

    public static void debug(String message, Throwable ex) {
        LogUtil.getImpl().debug(message, ex);
    }

    public static void info(String message) {
        LogUtil.getImpl().info(message);
    }

    public static void error(String message) {
        LogUtil.getImpl().error(message);
    }

    public static void error(String message, Throwable ex) {
        LogUtil.getImpl().error(message, ex);
    }

    public static void warn(String message) {
        LogUtil.getImpl().warn(message);
    }

    public static void setImpl(ILogger impl) {
        _impl = impl;
    }

    private static ILogger getImpl() {
        if (_impl == null) {
            _impl = new DefaultLogger();
        }
        return _impl;
    }

    public static class DebugLogger
    implements ILogger {
        private PrintStream out;
        private PrintStream err;
        private Level _level;

        public DebugLogger(PrintStream out, PrintStream err) {
            this(out, err, Level.DEBUG);
        }

        public DebugLogger(PrintStream out, PrintStream err, Level level) {
            this.out = out;
            this.err = err;
            this._level = level;
        }

        @Override
        public boolean isDebugEnabled() {
            return this._level == Level.DEBUG;
        }

        @Override
        public void debug(String message) {
            if (this._level.ordinal() >= Level.DEBUG.ordinal()) {
                this.out.println(message);
            }
        }

        @Override
        public void debug(String message, Throwable ex) {
            if (this._level.ordinal() >= Level.DEBUG.ordinal()) {
                this.out.println(message);
                ex.printStackTrace();
            }
        }

        @Override
        public void info(String message) {
            if (this._level.ordinal() >= Level.INFO.ordinal()) {
                this.out.println(message);
            }
        }

        @Override
        public void error(String message) {
            if (this._level.ordinal() >= Level.ERROR.ordinal()) {
                this.err.println(message);
            }
        }

        @Override
        public void error(String message, Throwable ex) {
            if (this._level.ordinal() >= Level.ERROR.ordinal()) {
                this.err.println(message);
                ex.printStackTrace();
            }
        }

        @Override
        public void warn(String message) {
            if (this._level.ordinal() >= Level.WARN.ordinal()) {
                this.out.println(message);
            }
        }

        public static enum Level {
            ERROR,
            INFO,
            DEBUG,
            WARN;

        }
    }

    private static class DefaultLogger
    implements ILogger {
        private DefaultLogger() {
        }

        @Override
        public boolean isDebugEnabled() {
            return this.getLogger().isDebugEnabled();
        }

        @Override
        public void debug(String message) {
            this.getLogger().debug((Object)message);
        }

        @Override
        public void debug(String message, Throwable ex) {
            this.getLogger().debug((Object)message, ex);
        }

        @Override
        public void info(String message) {
            this.getLogger().info((Object)message);
        }

        @Override
        public void error(String message) {
            this.getLogger().error((Object)message);
        }

        @Override
        public void error(String message, Throwable ex) {
            this.getLogger().error((Object)message, ex);
        }

        @Override
        public void warn(String message) {
            this.getLogger().warn((Object)message);
        }

        private Logger getLogger() {
            String className = "com.kingdee.bos.qing";
            Logger logger = Logger.getLogger((String)className);
            return logger;
        }
    }

    public static interface ILogger {
        public boolean isDebugEnabled();

        public void debug(String var1);

        public void debug(String var1, Throwable var2);

        public void info(String var1);

        public void error(String var1);

        public void error(String var1, Throwable var2);

        public void warn(String var1);
    }
}

